/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.lock;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.client.internal.store.lock.LockingServerStoreProxy;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;

public class LockingServerStoreProxyImpl
implements LockingServerStoreProxy {
    private final ServerStoreProxy storeProxy;
    private final LockManager lockManager;

    public LockingServerStoreProxyImpl(ServerStoreProxy storeProxy, LockManager lockManager) {
        this.storeProxy = storeProxy;
        this.lockManager = lockManager;
    }

    @Override
    public String getCacheId() {
        return this.storeProxy.getCacheId();
    }

    @Override
    public void close() {
        this.storeProxy.close();
    }

    @Override
    public ServerStoreProxy.ChainEntry lock(final long key) throws TimeoutException {
        final Chain chain = this.lockManager.lock(key);
        return new ServerStoreProxy.ChainEntry(){

            @Override
            public void append(ByteBuffer payLoad) throws TimeoutException {
                LockingServerStoreProxyImpl.this.append(key, payLoad);
            }

            @Override
            public void replaceAtHead(Chain equivalent) {
                LockingServerStoreProxyImpl.this.replaceAtHead(key, chain, equivalent);
            }

            @Override
            public boolean isEmpty() {
                return chain.isEmpty();
            }

            @Override
            public int length() {
                return chain.length();
            }

            @Override
            public Iterator<Element> iterator() {
                return chain.iterator();
            }
        };
    }

    @Override
    public void unlock(long key, boolean localonly) throws TimeoutException {
        this.lockManager.unlock(key, localonly);
    }

    @Override
    public ServerStoreProxy.ChainEntry get(long key) throws TimeoutException {
        return this.storeProxy.get(key);
    }

    @Override
    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        this.storeProxy.append(key, payLoad);
    }

    @Override
    public ServerStoreProxy.ChainEntry getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        return this.storeProxy.getAndAppend(key, payLoad);
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        this.storeProxy.replaceAtHead(key, expect, update);
    }

    @Override
    public void clear() throws TimeoutException {
        this.storeProxy.clear();
    }

    @Override
    public Iterator<Chain> iterator() throws TimeoutException {
        return this.storeProxy.iterator();
    }
}

