/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.StatType;
import com.tc.text.PrettyPrintable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

class InFlightStats
implements PrettyPrintable {
    private final List<Combo> values = new ArrayList<Combo>();
    private final LongAdder totalCount = new LongAdder();

    public InFlightStats() {
        this.values.add(new Combo(StatType.CLIENT_ENCODE, StatType.CLIENT_SEND));
        this.values.add(new Combo(StatType.CLIENT_SEND, StatType.CLIENT_SENT));
        this.values.add(new Combo(StatType.CLIENT_SENT, StatType.CLIENT_RECEIVED));
        this.values.add(new Combo(StatType.CLIENT_RECEIVED, StatType.CLIENT_COMPLETE));
        this.values.add(new Combo(StatType.CLIENT_COMPLETE, StatType.CLIENT_GOT));
        this.values.add(new Combo(StatType.CLIENT_GOT, StatType.CLIENT_DECODED));
        this.values.add(new Combo(StatType.CLIENT_COMPLETE, StatType.CLIENT_RETIRED));
        this.values.add(new Combo(StatType.CLIENT_SENT, StatType.CLIENT_RETIRED));
        this.values.add(new Combo(StatType.CLIENT_ENCODE, StatType.CLIENT_DECODED));
        this.values.add(new Combo(StatType.SERVER_ADD, StatType.SERVER_SCHEDULE));
        this.values.add(new Combo(StatType.SERVER_SCHEDULE, StatType.SERVER_BEGININVOKE));
        this.values.add(new Combo(StatType.SERVER_BEGININVOKE, StatType.SERVER_ENDINVOKE));
    }

    public void collect(long[] input) {
        this.values.forEach(c -> ((Combo)c).add(input));
        this.totalCount.increment();
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap map = new LinkedHashMap();
        if (this.totalCount.sum() > 0L) {
            this.values.forEach(c -> map.put(c.toString(), ((Combo)c).value() / this.totalCount.sum()));
        }
        return map;
    }

    private static class Combo {
        private final StatType from;
        private final StatType to;
        private final LongAdder value = new LongAdder();

        public Combo(StatType from, StatType to) {
            this.from = from;
            this.to = to;
        }

        private void add(long[] vals) {
            this.value.add(vals[this.to.ordinal()] - vals[this.from.ordinal()]);
        }

        private long value() {
            return this.value.sum();
        }

        public String toString() {
            return this.from.description() + "->" + this.to.description();
        }
    }
}

