/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.TableSkeleton;

public class Table
extends TableSkeleton
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static Builder newBuilder(String ... innerStatisticNames) {
        return new Builder(innerStatisticNames);
    }

    private Table(String ... innerStatisticNames) {
        super(innerStatisticNames);
    }

    public static interface RowBuilder {
        public <T extends Serializable> RowBuilder setStatistic(String var1, StatisticType var2, T var3);
    }

    public static class Builder {
        private final Table table;

        private Builder(String ... innerStatisticNames) {
            this.table = new Table(innerStatisticNames);
        }

        public <T extends Serializable> Builder setStatistic(String rowName, String statisticName, StatisticType type, T value) {
            this.table.insert(rowName, statisticName, type, value);
            return this;
        }

        public Builder withRow(final String rowName, Consumer<RowBuilder> c) {
            c.accept(new RowBuilder(){

                @Override
                public <T extends Serializable> RowBuilder setStatistic(String statisticName, StatisticType type, T value) {
                    table.insert(rowName, statisticName, type, value);
                    return this;
                }
            });
            return this;
        }

        public Builder withRows(Collection<String> rowNames, BiConsumer<String, RowBuilder> c) {
            rowNames.forEach(rowName -> c.accept((String)rowName, new RowBuilder((String)rowName){
                final /* synthetic */ String val$rowName;
                {
                    this.val$rowName = string;
                }

                @Override
                public <T extends Serializable> RowBuilder setStatistic(String statisticName, StatisticType type, T value) {
                    table.insert(this.val$rowName, statisticName, type, value);
                    return this;
                }
            }));
            return this;
        }

        public Table build() {
            return this.table;
        }
    }
}

