/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived.latency;

import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.derived.histogram.BarSplittingBiasedHistogram;
import org.terracotta.statistics.derived.histogram.Histogram;
import org.terracotta.statistics.derived.latency.LatencyHistogramQuery;
import org.terracotta.statistics.derived.latency.LatencyHistogramStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;

public class DefaultLatencyHistogramStatistic
implements LatencyHistogramStatistic,
ChainedEventObserver {
    private final BarSplittingBiasedHistogram histogram;
    private final LongSupplier timeSupplier;
    private final long pruningDelay;
    private final LatencyHistogramQuery query = new LatencyHistogramQuery(){

        @Override
        public Long minimum() {
            return DefaultLatencyHistogramStatistic.nullOrVal(DefaultLatencyHistogramStatistic.this.histogram.getMinimum());
        }

        @Override
        public Long maximum() {
            return DefaultLatencyHistogramStatistic.nullOrVal(DefaultLatencyHistogramStatistic.this.histogram.getMaximum());
        }

        @Override
        public long count() {
            return DefaultLatencyHistogramStatistic.this.histogram.size();
        }

        @Override
        public Long percentile(double percent) {
            return DefaultLatencyHistogramStatistic.nullOrVal(percent == 0.0 ? DefaultLatencyHistogramStatistic.this.histogram.getMinimum() : Math.nextDown(DefaultLatencyHistogramStatistic.this.histogram.getQuantileBounds(percent)[1]));
        }

        @Override
        public long[] percentileBounds(double percent) {
            if (percent == 0.0) {
                long[] lArray;
                double v = DefaultLatencyHistogramStatistic.this.histogram.getMinimum();
                if (Double.isNaN(v)) {
                    lArray = null;
                } else {
                    long[] lArray2 = new long[2];
                    lArray2[0] = (long)v;
                    lArray = lArray2;
                    lArray2[1] = (long)v;
                }
                return lArray;
            }
            double[] bounds = DefaultLatencyHistogramStatistic.this.histogram.getQuantileBounds(percent);
            if (Double.isNaN(bounds[0]) || Double.isNaN(bounds[1])) {
                return null;
            }
            return new long[]{(long)bounds[0], (long)Math.nextDown(bounds[1])};
        }

        @Override
        public List<Histogram.Bucket> buckets() {
            return DefaultLatencyHistogramStatistic.this.histogram.getBuckets();
        }
    };
    private long nextPruning;

    public DefaultLatencyHistogramStatistic(double phi, int bucketCount, Duration window, LongSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.histogram = new BarSplittingBiasedHistogram(phi, bucketCount, window.toNanos());
        this.pruningDelay = window.toNanos() / 2L;
    }

    public DefaultLatencyHistogramStatistic(double phi, int bucketCount, Duration window) {
        this(phi, bucketCount, window, Time::time);
    }

    @Override
    public List<Histogram.Bucket> buckets() {
        return this.query(LatencyHistogramQuery::buckets);
    }

    @Override
    public long count() {
        return this.query(LatencyHistogramQuery::count);
    }

    @Override
    public Long minimum() {
        return this.query(LatencyHistogramQuery::minimum);
    }

    @Override
    public Long maximum() {
        return this.query(LatencyHistogramQuery::maximum);
    }

    @Override
    public Long percentile(double percent) {
        return this.query(h -> h.percentile(percent));
    }

    @Override
    public long[] percentileBounds(double percent) {
        return this.query(h -> h.percentileBounds(percent));
    }

    @Override
    public synchronized void event(long time, long latency) {
        this.histogram.event(latency, time);
        this.tryExpire(false, () -> time);
    }

    @Override
    public synchronized <T> T query(Function<LatencyHistogramQuery, T> fn) {
        this.tryExpire(true, this.timeSupplier);
        return fn.apply(this.query);
    }

    public String toString() {
        return this.query(query -> "{count=" + query.count() + ", minimum=" + query.minimum() + ", maximum=" + query.maximum() + ", median=" + query.median() + '}');
    }

    private void tryExpire(boolean force, LongSupplier time) {
        long now = time.getAsLong();
        if (force || now >= this.nextPruning) {
            this.nextPruning = now + this.pruningDelay;
            this.histogram.expire(now);
        }
    }

    private static Long nullOrVal(double val) {
        return Double.isNaN(val) ? null : Long.valueOf((long)val);
    }
}

