/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.util.EnumSet;
import org.terracotta.runnel.EnumMapping;
import org.terracotta.runnel.EnumMappingBuilder;

public enum EhcacheMessageType {
    VALIDATE,
    VALIDATE_SERVER_STORE,
    PREPARE_FOR_DESTROY,
    GET_AND_APPEND,
    APPEND,
    REPLACE,
    CLIENT_INVALIDATION_ACK,
    CLIENT_INVALIDATION_ALL_ACK,
    CLEAR,
    GET_STORE,
    LOCK,
    UNLOCK,
    GET_STATE_REPO,
    PUT_IF_ABSENT,
    ENTRY_SET,
    CHAIN_REPLICATION_OP,
    CLEAR_INVALIDATION_COMPLETE,
    INVALIDATION_COMPLETE;

    public static final String MESSAGE_TYPE_FIELD_NAME = "opCode";
    public static final int MESSAGE_TYPE_FIELD_INDEX = 10;
    public static final EnumMapping<EhcacheMessageType> EHCACHE_MESSAGE_TYPES_ENUM_MAPPING;
    public static final EnumSet<EhcacheMessageType> LIFECYCLE_MESSAGES;
    public static final EnumSet<EhcacheMessageType> STORE_OPERATION_MESSAGES;
    public static final EnumSet<EhcacheMessageType> STATE_REPO_OPERATION_MESSAGES;
    public static final EnumSet<EhcacheMessageType> TRACKED_OPERATION_MESSAGES;
    public static final EnumSet<EhcacheMessageType> PASSIVE_REPLICATION_MESSAGES;

    public static boolean isLifecycleMessage(EhcacheMessageType value) {
        return LIFECYCLE_MESSAGES.contains((Object)value);
    }

    public static boolean isStoreOperationMessage(EhcacheMessageType value) {
        return STORE_OPERATION_MESSAGES.contains((Object)value);
    }

    public static boolean isStateRepoOperationMessage(EhcacheMessageType value) {
        return STATE_REPO_OPERATION_MESSAGES.contains((Object)value);
    }

    public static boolean isTrackedOperationMessage(EhcacheMessageType value) {
        return TRACKED_OPERATION_MESSAGES.contains((Object)value);
    }

    public static boolean isPassiveReplicationMessage(EhcacheMessageType value) {
        return PASSIVE_REPLICATION_MESSAGES.contains((Object)value);
    }

    static {
        EHCACHE_MESSAGE_TYPES_ENUM_MAPPING = EnumMappingBuilder.newEnumMappingBuilder(EhcacheMessageType.class).mapping(VALIDATE, 1).mapping(VALIDATE_SERVER_STORE, 2).mapping(PREPARE_FOR_DESTROY, 3).mapping(GET_AND_APPEND, 21).mapping(APPEND, 22).mapping(REPLACE, 23).mapping(CLIENT_INVALIDATION_ACK, 24).mapping(CLIENT_INVALIDATION_ALL_ACK, 25).mapping(CLEAR, 26).mapping(GET_STORE, 27).mapping(LOCK, 28).mapping(UNLOCK, 29).mapping(GET_STATE_REPO, 41).mapping(PUT_IF_ABSENT, 42).mapping(ENTRY_SET, 43).mapping(CHAIN_REPLICATION_OP, 61).mapping(CLEAR_INVALIDATION_COMPLETE, 63).mapping(INVALIDATION_COMPLETE, 64).build();
        LIFECYCLE_MESSAGES = EnumSet.of(VALIDATE, VALIDATE_SERVER_STORE, PREPARE_FOR_DESTROY);
        STORE_OPERATION_MESSAGES = EnumSet.of(GET_AND_APPEND, new EhcacheMessageType[]{APPEND, REPLACE, CLIENT_INVALIDATION_ACK, CLIENT_INVALIDATION_ALL_ACK, CLEAR, GET_STORE, LOCK, UNLOCK});
        STATE_REPO_OPERATION_MESSAGES = EnumSet.of(GET_STATE_REPO, PUT_IF_ABSENT, ENTRY_SET);
        TRACKED_OPERATION_MESSAGES = EnumSet.of(CHAIN_REPLICATION_OP, PUT_IF_ABSENT, GET_AND_APPEND, APPEND, CLEAR);
        PASSIVE_REPLICATION_MESSAGES = EnumSet.of(CHAIN_REPLICATION_OP, CLEAR_INVALIDATION_COMPLETE, INVALIDATION_COMPLETE);
    }
}

