/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.util.concurrent.SetOnceFlag;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class ConnectionWatcher
implements MessageTransportListener {
    private final ClientMessageTransport cmt;
    private final ClientConnectionEstablisher cce;
    private final ReferenceQueue<MessageTransportListener> stopQueue = new ReferenceQueue();
    private final SetOnceFlag stopped = new SetOnceFlag();
    private final WeakReference<MessageTransportListener> targetHolder;

    public ConnectionWatcher(ClientMessageTransport cmt, MessageTransportListener target, ClientConnectionEstablisher cce) {
        this.cmt = cmt;
        this.targetHolder = new WeakReference<MessageTransportListener>(target, this.stopQueue);
        this.cce = cce;
    }

    private boolean checkForStop() {
        if (this.stopQueue.poll() == this.targetHolder) {
            this.stopped.set();
        }
        return this.stopped.isSet();
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.cce.quitReconnectAttempts();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportClosed(transport);
        }
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (transport.getProductID().isReconnectEnabled()) {
            this.cce.asyncReconnect(this.cmt, this::checkForStop);
        } else {
            this.cce.quitReconnectAttempts();
            transport.close();
        }
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportDisconnected(transport, forcedDisconnect);
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportConnectAttempt(transport);
        }
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportConnected(transport);
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.cce.quitReconnectAttempts();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportReconnectionRejected(transport);
        }
    }
}

