/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.basic;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.BufferManager;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import com.tc.text.PrettyPrintable;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConnection
implements TCConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicConnection.class);
    private final long connect = System.currentTimeMillis();
    private volatile long last = System.currentTimeMillis();
    private volatile long received = System.currentTimeMillis();
    private final Function<TCConnection, Socket> closeRunnable;
    private final Consumer<WireProtocolMessage> write;
    private final TCProtocolAdaptor adaptor;
    private BufferManager buffer;
    private final BufferManagerFactory bufferManagerFactory;
    private Socket src;
    private boolean established = false;
    private boolean connected = true;
    private final List<TCConnectionEventListener> listeners = new LinkedList<TCConnectionEventListener>();
    private ExecutorService readerExec;

    public BasicConnection(Socket src, Consumer<WireProtocolMessage> write, Function<TCConnection, Socket> close) {
        this.src = src;
        this.write = write;
        this.closeRunnable = close;
        this.adaptor = null;
        this.bufferManagerFactory = null;
    }

    public BasicConnection(TCProtocolAdaptor adapter, BufferManagerFactory buffers, Function<TCConnection, Socket> close) {
        this.bufferManagerFactory = buffers;
        this.write = message -> {
            BasicConnection basicConnection = this;
            synchronized (basicConnection) {
                try {
                    if (this.src != null) {
                        boolean interrupted = Thread.interrupted();
                        int totalLen = message.getTotalLength();
                        int moved = 0;
                        int sent = 0;
                        TCByteBuffer[] data = message.getEntireMessageData();
                        while (moved < totalLen) {
                            for (TCByteBuffer b : data) {
                                moved += this.buffer.forwardToWriteBuffer(b.getNioBuffer());
                            }
                            sent += this.buffer.sendFromBuffer();
                        }
                        while (sent < totalLen) {
                            sent += this.buffer.sendFromBuffer();
                        }
                        message.wasSent();
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (IOException ioe) {
                    this.close(0L);
                }
                catch (Throwable t) {
                    this.close(0L);
                }
            }
        };
        this.closeRunnable = close;
        this.adaptor = adapter;
    }

    @Override
    public long getConnectTime() {
        return this.connect;
    }

    @Override
    public long getIdleTime() {
        return System.currentTimeMillis() - this.last;
    }

    @Override
    public long getIdleReceiveTime() {
        return System.currentTimeMillis() - this.received;
    }

    void markReceived() {
        this.received = System.currentTimeMillis();
    }

    @Override
    public synchronized void addListener(TCConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(TCConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void asynchClose() {
        this.close(0L);
    }

    @Override
    public synchronized Socket detach() throws IOException {
        try {
            this.established = false;
            Socket socket = this.closeRunnable.apply(this);
            Socket socket2 = socket == null ? this.src : socket;
            return socket2;
        }
        catch (Exception e) {
            Socket socket = null;
            return socket;
        }
        finally {
            this.established = false;
            this.connected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(long timeout) {
        try {
            Socket socket = this.detach();
            if (socket != null) {
                try {
                    if (this.buffer != null) {
                        this.buffer.close();
                    }
                }
                catch (EOFException eof) {
                    LOGGER.debug("closed", (Throwable)eof);
                }
                catch (IOException ioe) {
                    LOGGER.warn("failed to close buffer manager", (Throwable)ioe);
                }
                socket.getChannel().close();
                socket.close();
                this.readerExec.shutdown();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.fireClosed();
        }
    }

    private void fireClosed() {
        TCConnectionEvent event = new TCConnectionEvent(this);
        this.listeners.forEach(l -> l.closeEvent(event));
    }

    @Override
    public synchronized Socket connect(TCSocketAddress addr, int timeout) throws IOException, TCTimeoutException {
        boolean interrupted = Thread.interrupted();
        SocketChannel channel = SocketChannel.open(new InetSocketAddress(addr.getAddress(), addr.getPort()));
        this.src = channel.socket();
        this.buffer = this.bufferManagerFactory.createBufferManager(channel, true);
        if (this.buffer == null) {
            throw new IOException("buffer manager not provided");
        }
        this.connected = this.src.isConnected();
        if (this.connected) {
            this.readMessages();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this.src;
    }

    @Override
    public boolean asynchConnect(TCSocketAddress addr) throws IOException {
        try {
            return this.connect(addr, 0).isConnected();
        }
        catch (TCTimeoutException timeout) {
            throw new IOException(timeout);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized boolean isClosed() {
        return !this.connected;
    }

    @Override
    public TCSocketAddress getLocalAddress() {
        return new TCSocketAddress(this.src.getLocalAddress(), this.src.getLocalPort());
    }

    @Override
    public TCSocketAddress getRemoteAddress() {
        return new TCSocketAddress(this.src.getInetAddress(), this.src.getPort());
    }

    @Override
    public synchronized void setTransportEstablished() {
        this.established = true;
    }

    @Override
    public synchronized boolean isTransportEstablished() {
        return this.established;
    }

    @Override
    public boolean isClosePending() {
        return false;
    }

    @Override
    public void putMessage(TCNetworkMessage message) {
        this.last = System.currentTimeMillis();
        if (message instanceof WireProtocolMessage) {
            this.write.accept(this.finalizeWireProtocolMessage((WireProtocolMessage)message, 1));
        } else {
            this.write.accept(this.buildWireProtocolMessage(message));
        }
    }

    private void readMessages() {
        this.readerExec = Executors.newFixedThreadPool(1, r -> new Thread(r, "BasicConnectionReader-" + this.src.getLocalSocketAddress() + "<-" + this.src.getRemoteSocketAddress()));
        this.readerExec.submit(() -> {
            while (!this.isClosed()) {
                try {
                    long amount = this.buffer.recvToBuffer();
                    if (amount > 0L) {
                        if (amount > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)"overflow long");
                        }
                        int transfer = 0;
                        while ((long)transfer < amount) {
                            int read = 0;
                            TCByteBuffer[] buffers = this.adaptor.getReadBuffers();
                            for (int i = 0; i < buffers.length; ++i) {
                                read += this.buffer.forwardFromReadBuffer(buffers[i].getNioBuffer());
                                if (buffers[i].hasRemaining()) break;
                            }
                            this.adaptor.addReadData(this, buffers, read);
                            transfer += read;
                        }
                        this.markReceived();
                        continue;
                    }
                    if (amount >= 0L) continue;
                    this.close(0L);
                }
                catch (EOFException eof) {
                    if (this.isClosed()) continue;
                    this.close(0L);
                }
                catch (TCProtocolException | IOException ioe) {
                    if (this.isClosed()) continue;
                    LOGGER.warn("error reading from connection", (Throwable)ioe);
                    this.close(0L);
                }
            }
        });
    }

    private WireProtocolMessage buildWireProtocolMessage(TCNetworkMessage message) {
        Assert.eval(!(message instanceof WireProtocolMessage));
        TCNetworkMessage payload = message;
        WireProtocolMessage wireMessage = WireProtocolMessageImpl.wrapMessage(message, this);
        Assert.eval(wireMessage.getSentCallback() == null);
        Runnable callback = payload.getSentCallback();
        if (callback != null) {
            wireMessage.setSentCallback(callback);
        }
        return this.finalizeWireProtocolMessage(wireMessage, 1);
    }

    private WireProtocolMessage finalizeWireProtocolMessage(WireProtocolMessage message, int messageCount) {
        WireProtocolHeader hdr = (WireProtocolHeader)message.getHeader();
        hdr.setSourceAddress(this.getLocalAddress().getAddressBytes());
        hdr.setSourcePort(this.getLocalAddress().getPort());
        hdr.setDestinationAddress(this.getRemoteAddress().getAddressBytes());
        hdr.setDestinationPort(this.getRemoteAddress().getPort());
        hdr.setMessageCount(messageCount);
        hdr.computeChecksum();
        return message;
    }

    @Override
    public Map<String, ?> getState() {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        state.put("localAddress", this.getLocalAddress());
        state.put("remoteAddress", this.getRemoteAddress());
        state.put("connectTime", new Date(this.getConnectTime()));
        state.put("receiveIdleTime", this.getIdleReceiveTime());
        state.put("idleTime", this.getIdleTime());
        state.put("closed", this.isClosed());
        state.put("connected", this.isConnected());
        state.put("closePending", this.isClosePending());
        state.put("transportConnected", this.isTransportEstablished());
        if (this.buffer instanceof PrettyPrintable) {
            state.put("buffer", ((PrettyPrintable)((Object)this.buffer)).getStateMap());
        } else {
            state.put("buffer", this.buffer.toString());
        }
        return state;
    }
}

