/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.lock;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.common.internal.store.Chain;

public class LockingServerStoreProxy
implements ServerStoreProxy,
LockManager {
    private final ServerStoreProxy storeProxy;
    private final LockManager lockManager;

    public LockingServerStoreProxy(ServerStoreProxy storeProxy, LockManager lockManager) {
        this.storeProxy = storeProxy;
        this.lockManager = lockManager;
    }

    @Override
    public String getCacheId() {
        return this.storeProxy.getCacheId();
    }

    @Override
    public void close() {
        this.storeProxy.close();
    }

    @Override
    public Chain lock(long hash) throws TimeoutException {
        return this.lockManager.lock(hash);
    }

    @Override
    public void unlock(long hash) throws TimeoutException {
        this.lockManager.unlock(hash);
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        return this.storeProxy.get(key);
    }

    @Override
    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        this.storeProxy.append(key, payLoad);
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        return this.storeProxy.getAndAppend(key, payLoad);
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        this.storeProxy.replaceAtHead(key, expect, update);
    }

    @Override
    public void clear() throws TimeoutException {
        this.storeProxy.clear();
    }
}

