/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.EntityID;
import org.terracotta.exception.ConnectionClosedException;

public class LocalConnectionClosedException
extends ConnectionClosedException {
    private final EntityID entityID;

    public LocalConnectionClosedException(EntityID eid, String description, Throwable cause) {
        super(description, cause);
        this.entityID = eid;
    }

    public LocalConnectionClosedException(EntityID eid, ConnectionClosedException cause) {
        super(cause.getDescription(), cause);
        this.entityID = eid;
    }

    private static String fixDescription(EntityID eid, String description) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(eid.getClassName());
        buffer.append(":");
        buffer.append(eid.getEntityName());
        buffer.append(" - ");
        buffer.append(description);
        return buffer.toString();
    }

    @Override
    public String getEntityName() {
        return this.entityID.getEntityName();
    }

    @Override
    public String getClassName() {
        return this.entityID.getClassName();
    }

    @Override
    public String getLocalizedMessage() {
        return LocalConnectionClosedException.fixDescription(this.entityID, super.getDescription());
    }

    @Override
    public String getMessage() {
        return LocalConnectionClosedException.fixDescription(this.entityID, super.getDescription());
    }
}

