/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.clustered.client.internal.store.ReconnectInProgressException;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;

public class ReconnectingServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconnectingServerStoreProxy.class);
    private final AtomicReference<ServerStoreProxy> delegateRef;
    private final Runnable onReconnect;

    public ReconnectingServerStoreProxy(ServerStoreProxy serverStoreProxy, Runnable onReconnect) {
        this.delegateRef = new AtomicReference<ServerStoreProxy>(serverStoreProxy);
        this.onReconnect = onReconnect;
    }

    @Override
    public String getCacheId() {
        return this.proxy().getCacheId();
    }

    @Override
    public void close() {
        try {
            this.proxy().close();
        }
        catch (ConnectionClosedException | ConnectionShutdownException e) {
            LOGGER.debug("Store was already closed, since connection was closed");
        }
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        return this.onStoreProxy(serverStoreProxy -> serverStoreProxy.get(key));
    }

    @Override
    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.append(key, payLoad);
            return null;
        });
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        return this.onStoreProxy(serverStoreProxy -> serverStoreProxy.getAndAppend(key, payLoad));
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.onStoreProxy(serverStoreProxy -> {
                serverStoreProxy.replaceAtHead(key, expect, update);
                return null;
            });
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.clear();
            return null;
        });
    }

    private ServerStoreProxy proxy() {
        return this.delegateRef.get();
    }

    private <T> T onStoreProxy(TimeoutExceptionFunction<ServerStoreProxy, T> function) throws TimeoutException {
        ServerStoreProxy storeProxy = this.proxy();
        try {
            return function.apply(storeProxy);
        }
        catch (ServerStoreProxyException sspe) {
            if (sspe.getCause() instanceof ConnectionClosedException) {
                if (this.delegateRef.compareAndSet(storeProxy, new ReconnectInProgressProxy(storeProxy.getCacheId()))) {
                    this.onReconnect.run();
                }
                return this.onStoreProxy(function);
            }
            throw sspe;
        }
    }

    private static class ReconnectInProgressProxy
    implements ServerStoreProxy {
        private final String cacheId;

        ReconnectInProgressProxy(String cacheId) {
            this.cacheId = cacheId;
        }

        @Override
        public String getCacheId() {
            return this.cacheId;
        }

        @Override
        public void close() {
            throw new ReconnectInProgressException();
        }

        @Override
        public Chain get(long key) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void append(long key, ByteBuffer payLoad) {
            throw new ReconnectInProgressException();
        }

        @Override
        public Chain getAndAppend(long key, ByteBuffer payLoad) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void replaceAtHead(long key, Chain expect, Chain update) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void clear() {
            throw new ReconnectInProgressException();
        }
    }

    @FunctionalInterface
    private static interface TimeoutExceptionFunction<U, V> {
        public V apply(U var1) throws TimeoutException;
    }
}

