/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.internal.ConnectionSource;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.core.HumanReadable;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class ClusteringServiceConfiguration
implements ServiceCreationConfiguration<ClusteringService>,
CacheManagerConfiguration<PersistentCacheManager>,
HumanReadable {
    public static final boolean DEFAULT_AUTOCREATE = false;
    private final ConnectionSource connectionSource;
    private final boolean autoCreate;
    private final ServerSideConfiguration serverConfiguration;
    private final Timeouts timeouts;
    private final Properties properties;

    public ClusteringServiceConfiguration(URI clusterUri) {
        this(clusterUri, Timeouts.DEFAULT);
    }

    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager) {
        this(servers, clusterTierManager, Timeouts.DEFAULT);
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts) {
        this(clusterUri, timeouts, null);
    }

    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts) {
        this(servers, clusterTierManager, timeouts, null);
    }

    public ClusteringServiceConfiguration(URI clusterUri, ServerSideConfiguration serverConfig) {
        this(clusterUri, Timeouts.DEFAULT, serverConfig);
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, ServerSideConfiguration serverConfig) {
        this(clusterUri, timeouts, false, serverConfig);
    }

    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts, ServerSideConfiguration serverConfig) {
        this(servers, clusterTierManager, timeouts, false, serverConfig);
    }

    public ClusteringServiceConfiguration(URI clusterUri, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(clusterUri, Timeouts.DEFAULT, autoCreate, serverConfig);
    }

    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(servers, clusterTierManager, Timeouts.DEFAULT, autoCreate, serverConfig);
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(clusterUri, timeouts, autoCreate, serverConfig, new Properties());
    }

    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(servers, clusterTierManager, timeouts, autoCreate, serverConfig, new Properties());
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig, Properties properties) {
        this(new ConnectionSource.ClusterUri(clusterUri), timeouts, autoCreate, serverConfig, properties);
    }

    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig, Properties properties) {
        this(new ConnectionSource.ServerList(servers, clusterTierManager), timeouts, autoCreate, serverConfig, properties);
    }

    public ClusteringServiceConfiguration(ConnectionSource connectionSource, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverSideConfiguration, Properties properties) {
        this.connectionSource = connectionSource;
        this.autoCreate = autoCreate;
        this.serverConfiguration = serverSideConfiguration;
        this.timeouts = Objects.requireNonNull(timeouts, "Operation timeouts cannot be null");
        this.properties = (Properties)Objects.requireNonNull(properties, "Properties cannot be null").clone();
    }

    protected ClusteringServiceConfiguration(ClusteringServiceConfiguration baseConfig) {
        Objects.requireNonNull(baseConfig, "Base configuration cannot be null");
        this.connectionSource = baseConfig.getConnectionSource();
        this.timeouts = baseConfig.getTimeouts();
        this.autoCreate = baseConfig.isAutoCreate();
        this.serverConfiguration = baseConfig.getServerConfiguration();
        this.properties = baseConfig.getProperties();
    }

    public URI getClusterUri() {
        return this.connectionSource.getClusterUri();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public ServerSideConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    @Deprecated
    public Duration getReadOperationTimeout() {
        return this.timeouts.getReadOperationTimeout();
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    public CacheManagerBuilder<PersistentCacheManager> builder(CacheManagerBuilder<? extends CacheManager> other) {
        return other.using((ServiceCreationConfiguration)this);
    }

    public String readableString() {
        return this.getClass().getName() + ":\n    " + this.getConnectionSource() + "\n    timeouts: " + this.getTimeouts() + "\n    autoCreate: " + this.isAutoCreate() + "\n    defaultServerResource: " + this.serverConfiguration.getDefaultServerResource() + "\n    " + this.readablePoolsString();
    }

    private String readablePoolsString() {
        StringBuilder pools = new StringBuilder("resourcePools:\n");
        this.serverConfiguration.getResourcePools().forEach((key, value) -> {
            pools.append("        ");
            pools.append((String)key);
            pools.append(": ");
            pools.append(value);
            pools.append("\n");
        });
        return pools.toString();
    }
}

