/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.ServerID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.ClearTextBufferManagerFactory;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.core.TCListener;
import com.tc.net.protocol.ClientNetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManagerImpl;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.ClientMessageChannelImpl;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.GeneratedMessageFactory;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageTransportFactoryImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.NetworkListenerImpl;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.tcm.ServerMessageChannelImpl;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageFactoryImpl;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.ConnectionHealthCheckerEchoImpl;
import com.tc.net.protocol.transport.ConnectionHealthCheckerImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.DisabledHealthCheckerConfigImpl;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL2;
import com.tc.net.protocol.transport.ServerMessageTransport;
import com.tc.net.protocol.transport.ServerStackProvider;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandlerForL1;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.TransportMessageFactoryImpl;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactoryImpl;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.object.session.NullSessionManager;
import com.tc.object.session.SessionManager;
import com.tc.object.session.SessionProvider;
import com.tc.operatorevent.NodeNameProvider;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationsManagerImpl
implements CommunicationsManager {
    private static final Logger logger = LoggerFactory.getLogger(CommunicationsManager.class);
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final Set<NetworkListener> listeners = new HashSet<NetworkListener>();
    private final ReentrantLock licenseLock = new ReentrantLock();
    private final TCConnectionManager connectionManager;
    private final boolean privateConnMgr;
    private final NetworkStackHarnessFactory stackHarnessFactory;
    private final TransportHandshakeMessageFactory transportMessageFactory;
    private final MessageMonitor monitor;
    private final TCMessageRouter messageRouter;
    private final HealthCheckerConfig healthCheckerConfig;
    private final ConnectionPolicy connectionPolicy;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;
    protected final ConcurrentHashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new ConcurrentHashMap();
    protected final ConcurrentHashMap<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping = new ConcurrentHashMap();
    private ConnectionHealthChecker connectionHealthChecker;
    private ServerID serverID = ServerID.NULL_ID;
    private int callbackPort = -1;
    private final TransportHandshakeErrorHandler handshakeErrHandler;
    private final String commsMgrName;
    private final SessionManager sessionManager = new NullSessionManager();

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy) {
        this(commsMgrName, monitor, (TCMessageRouter)new TCMessageRouterImpl(), stackHarnessFactory, null, connectionPolicy, 0, new DisabledHealthCheckerConfigImpl(), (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForL1(), Collections.emptyMap(), Collections.emptyMap());
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, int workerCommCount) {
        this(commsMgrName, monitor, (TCMessageRouter)new TCMessageRouterImpl(), stackHarnessFactory, null, connectionPolicy, workerCommCount, new DisabledHealthCheckerConfigImpl(), (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForL1(), Collections.emptyMap(), Collections.emptyMap());
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, HealthCheckerConfig config) {
        this(commsMgrName, monitor, new TCMessageRouterImpl(), stackHarnessFactory, connectionPolicy, config, Collections.emptyMap(), Collections.emptyMap());
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, HealthCheckerConfig config, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, null, connectionPolicy, 0, config, (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForL1(), messageTypeClassMapping, messageTypeFactoryMapping);
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig config, ServerID serverID, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, null, connectionPolicy, workerCommCount, config, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL2.SINGLETON, (BufferManagerFactory)new ClearTextBufferManagerFactory());
        this.serverID = serverID;
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig config, ServerID serverID, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping, BufferManagerFactory bufferManagerFactory) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, null, connectionPolicy, workerCommCount, config, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL2.SINGLETON, bufferManagerFactory);
        this.serverID = serverID;
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connMgr, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig healthCheckerConf, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, connMgr, connectionPolicy, workerCommCount, healthCheckerConf, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL1.SINGLETON, (BufferManagerFactory)new ClearTextBufferManagerFactory());
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connMgr, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig healthCheckerConf, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, ReconnectionRejectedHandler reconnectionRejectedHandler, BufferManagerFactory bufferManagerFactory) {
        this.commsMgrName = commsMgrName;
        this.monitor = monitor;
        this.messageRouter = messageRouter;
        this.transportMessageFactory = new TransportMessageFactoryImpl();
        this.connectionPolicy = connectionPolicy;
        this.stackHarnessFactory = stackHarnessFactory;
        this.healthCheckerConfig = healthCheckerConf;
        this.handshakeErrHandler = transportHandshakeErrorHandler;
        this.privateConnMgr = connMgr == null;
        this.messageTypeClassMapping.putAll(messageTypeClassMapping);
        this.messageTypeFactoryMapping.putAll(this.messageTypeFactoryMapping);
        this.reconnectionRejectedHandler = reconnectionRejectedHandler;
        Assert.assertNotNull(commsMgrName);
        this.connectionManager = null == connMgr ? new TCConnectionManagerImpl(commsMgrName, workerCommCount, this.healthCheckerConfig, bufferManagerFactory) : connMgr;
        Assert.eval(this.healthCheckerConfig != null);
        this.connectionHealthChecker = this.healthCheckerConfig.isHealthCheckerEnabled() ? new ConnectionHealthCheckerImpl(this.healthCheckerConfig, this.connectionManager) : new ConnectionHealthCheckerEchoImpl();
        this.connectionHealthChecker.start();
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.commsMgrName);
        map.put("connectionPolicy", this.connectionPolicy.toString());
        map.put("connectionManager", this.connectionManager.getStateMap());
        return map;
    }

    @Override
    public TCConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public boolean isInShutdown() {
        return this.shutdown.isSet();
    }

    @Override
    public void shutdown() {
        if (this.shutdown.attemptSet()) {
            this.connectionHealthChecker.stop();
            if (this.privateConnMgr) {
                this.connectionManager.shutdown();
            }
        } else {
            logger.warn("shutdown already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkListener[] getAllListeners() {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new NetworkListener[this.listeners.size()]);
        }
    }

    @Override
    public void addClassMapping(TCMessageType messageType, Class<? extends TCMessage> messageClass) {
        this.messageTypeClassMapping.put(messageType, messageClass);
    }

    @Override
    public ClientMessageChannel createClientChannel(ProductID productId, SessionProvider sessions, int timeout) {
        return this.createClientChannel(productId, sessions, timeout, null, null);
    }

    public ClientMessageChannel createClientChannel(ProductID productId, SessionProvider sessions, int timeout, MessageTransportFactory transportFactory, TCMessageFactory messageFactory) {
        TCMessageFactory msgFactory;
        if (messageFactory == null) {
            msgFactory = new TCMessageFactoryImpl(sessions, this.monitor);
            for (Map.Entry<TCMessageType, Class<? extends TCMessage>> entry : this.messageTypeClassMapping.entrySet()) {
                msgFactory.addClassMapping(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<TCMessageType, Object> entry : this.messageTypeFactoryMapping.entrySet()) {
                msgFactory.addClassMapping(entry.getKey(), (GeneratedMessageFactory)entry.getValue());
            }
        } else {
            msgFactory = messageFactory;
        }
        ClientMessageChannelImpl rv = new ClientMessageChannelImpl(msgFactory, this.messageRouter, sessions, productId);
        if (transportFactory == null) {
            transportFactory = new MessageTransportFactoryImpl(this.transportMessageFactory, this.connectionHealthChecker, this.connectionManager, timeout, this.callbackPort, this.handshakeErrHandler, this.reconnectionRejectedHandler);
        }
        ClientNetworkStackHarness clientNetworkStackHarness = this.stackHarnessFactory.createClientHarness(transportFactory, rv, new MessageTransportListener[0]);
        clientNetworkStackHarness.finalizeStack();
        return rv;
    }

    @Override
    public NetworkListener createListener(TCSocketAddress addr, boolean transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, NodeNameProvider activeNameProvider) {
        return this.createListener(addr, transportDisconnectRemovesChannel, connectionIdFactory, true, null, activeNameProvider, t -> true);
    }

    @Override
    public NetworkListener createListener(TCSocketAddress addr, boolean transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, Predicate<MessageTransport> validation) {
        return this.createListener(addr, transportDisconnectRemovesChannel, connectionIdFactory, true, null, null, validation);
    }

    NetworkListener createListener(TCSocketAddress addr, boolean transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, boolean reuseAddr, WireProtocolMessageSink wireProtoMsgSnk, NodeNameProvider activeProvider, Predicate<MessageTransport> validation) {
        if (this.shutdown.isSet()) {
            throw new IllegalStateException("Comms manger shut down");
        }
        final TCMessageFactoryImpl msgFactory = new TCMessageFactoryImpl(this.sessionManager, this.monitor);
        for (Map.Entry<TCMessageType, Class<? extends TCMessage>> entry : this.messageTypeClassMapping.entrySet()) {
            msgFactory.addClassMapping(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<TCMessageType, Object> entry : this.messageTypeFactoryMapping.entrySet()) {
            msgFactory.addClassMapping(entry.getKey(), (GeneratedMessageFactory)entry.getValue());
        }
        ServerMessageChannelFactory channelFactory = new ServerMessageChannelFactory(){

            @Override
            public MessageChannelInternal createNewChannel(ChannelID id) {
                return new ServerMessageChannelImpl(id, CommunicationsManagerImpl.this.messageRouter, msgFactory, CommunicationsManagerImpl.this.serverID);
            }
        };
        if (!this.healthCheckerConfig.isCallbackPortListenerNeeded()) {
            this.callbackPort = addr.getPort();
        }
        ChannelManagerImpl channelManagerImpl = new ChannelManagerImpl(transportDisconnectRemovesChannel, channelFactory);
        return new NetworkListenerImpl(addr, this, channelManagerImpl, msgFactory, reuseAddr, connectionIdFactory, wireProtoMsgSnk, activeProvider, validation);
    }

    TCListener createCommsListener(TCSocketAddress addr, ServerMessageChannelFactory channelFactory, boolean resueAddr, Set<ConnectionID> initialConnectionIDs, NodeNameProvider activeProvider, Predicate<MessageTransport> validation, ConnectionIDFactory connectionIdFactory, WireProtocolMessageSink wireProtocolMessageSink) throws IOException {
        MessageTransportFactory transportFactory = new MessageTransportFactory(){

            @Override
            public ClientConnectionEstablisher createClientConnectionEstablisher() {
                throw new AssertionError();
            }

            @Override
            public ClientMessageTransport createNewTransport() {
                throw new AssertionError();
            }

            @Override
            public ServerMessageTransport createNewTransport(TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
                ServerMessageTransport rv = new ServerMessageTransport(handler, handshakeMessageFactory);
                rv.addTransportListeners(transportListeners);
                rv.addTransportListener(CommunicationsManagerImpl.this.connectionHealthChecker);
                return rv;
            }

            @Override
            public ServerMessageTransport createNewTransport(TCConnection connection, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
                ServerMessageTransport rv = new ServerMessageTransport(connection, handler, handshakeMessageFactory);
                rv.addTransportListeners(transportListeners);
                rv.addTransportListener(CommunicationsManagerImpl.this.connectionHealthChecker);
                return rv;
            }
        };
        ServerStackProvider stackProvider = new ServerStackProvider(initialConnectionIDs, activeProvider, validation, this.stackHarnessFactory, channelFactory, transportFactory, this.transportMessageFactory, connectionIdFactory, this.connectionPolicy, new WireProtocolAdaptorFactoryImpl(), wireProtocolMessageSink, this.licenseLock, this.commsMgrName);
        return this.connectionManager.createListener(addr, stackProvider, 512, resueAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListener(NetworkListener lsnr) {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            boolean added = this.listeners.add(lsnr);
            if (!added) {
                logger.warn("replaced an existing listener in the listener map");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListener(NetworkListener lsnr) {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(lsnr);
        }
    }

    public ConnectionHealthChecker getConnHealthChecker() {
        return this.connectionHealthChecker;
    }

    public void setConnHealthChecker(ConnectionHealthChecker checker) {
        this.connectionHealthChecker.stop();
        this.connectionHealthChecker = checker;
        this.connectionHealthChecker.start();
    }

    public TCMessageRouter getMessageRouter() {
        return this.messageRouter;
    }
}

