/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.net.core.TCConnection;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.LayeredNetworkStackHarness;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.LinkedList;
import java.util.List;

public class ServerNetworkStackHarness
extends LayeredNetworkStackHarness {
    protected MessageTransport transport;
    protected MessageChannelInternal channel;
    private final ServerMessageChannelFactory channelFactory;
    private final List<NetworkLayer> intermediate = new LinkedList<NetworkLayer>();
    private final SetOnceFlag finalized = new SetOnceFlag();

    public ServerNetworkStackHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport) {
        this.channelFactory = channelFactory;
        this.transport = transport;
    }

    @Override
    public final MessageTransport attachNewConnection(TCConnection connection) throws IllegalReconnectException {
        Assert.eval("Attempt to connect a transport to a stack that hasn't been finalized.", this.finalized.isSet());
        this.transport.attachNewConnection(connection);
        return this.transport;
    }

    @Override
    public final void finalizeStack() {
        if (!this.finalized.attemptSet()) {
            throw Assert.failure("Attempt to finalize an already finalized stack");
        }
        Assert.assertNotNull(this.transport);
        Assert.assertNotNull(this.channelFactory);
        this.channel = this.channelFactory.createNewChannel(new ChannelID(this.transport.getConnectionId().getChannelID()), this.transport.getConnectionId().getProductId());
        this.connectStack();
    }

    protected void connectStack() {
        NetworkLayer last = this.chainNetworkLayers(this.transport);
        last.setReceiveLayer(this.channel);
        this.channel.setSendLayer(last);
        MessageTransportListener listener = this.createTransportListener(this.channel);
        this.transport.addTransportListener(listener);
    }

    protected MessageTransportListener createTransportListener(MessageChannelInternal created) {
        return created;
    }

    @Override
    public MessageTransport getTransport() {
        return this.transport;
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "ServerNetworkStackHarness[ transport:" + this.transport + "channel" + this.channel + "]";
    }
}

