/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.util.Assert;
import java.io.Serializable;

public class ConnectionInfo
implements Serializable {
    public static final ConnectionInfo[] EMPTY_ARRAY = new ConnectionInfo[0];
    private final String hostname;
    private final int port;
    private final int server;
    private String s;

    public ConnectionInfo(String hostname, int port) {
        this(hostname, port, 0);
    }

    public ConnectionInfo(String hostname, int port, int server) {
        Assert.assertNotNull(hostname);
        Assert.assertTrue(port >= 0);
        this.hostname = hostname;
        this.port = port;
        this.server = server;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getServer() {
        return this.server;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionInfo) {
            ConnectionInfo other = (ConnectionInfo)o;
            return this.hostname.equals(other.getHostname()) && this.port == other.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.s == null ? (this.s = this.hostname + ":" + this.port) : this.s;
    }
}

