/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.api.Source;
import com.tc.async.api.StageQueueStats;
import com.tc.async.impl.ContextWrapper;
import com.tc.async.impl.StageQueue;
import com.tc.logging.TCLoggerProvider;
import com.tc.util.Assert;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public abstract class AbstractStageQueueImpl<EC>
implements StageQueue<EC> {
    private volatile boolean closed = false;
    private final AtomicInteger inflight = new AtomicInteger();
    final Logger logger;
    final String stageName;

    public AbstractStageQueueImpl(TCLoggerProvider loggerProvider, String stageName) {
        this.logger = loggerProvider.getLogger(Sink.class.getName() + ": " + stageName);
        this.stageName = stageName;
    }

    abstract SourceQueue[] getSources();

    void addInflight() {
        this.inflight.incrementAndGet();
    }

    @Override
    public void clear() {
        this.inflight.set(0);
    }

    Logger getLogger() {
        return this.logger;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public int size() {
        return this.inflight.get();
    }

    @Override
    public boolean isEmpty() {
        int val = this.inflight.get();
        Assert.assertTrue(val >= 0);
        return val == 0;
    }

    @Override
    public void close() {
        Assert.assertFalse(this.closed);
        this.closed = true;
        for (SourceQueue q : this.getSources()) {
            try {
                q.put(new CloseContext());
            }
            catch (InterruptedException ie) {
                this.logger.debug("closing stage", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
    }

    static class CloseContext<C>
    implements ContextWrapper<C> {
        @Override
        public void runWithHandler(EventHandler<C> handler) throws EventHandlerException {
        }
    }

    class HandledContext<C>
    implements ContextWrapper<C> {
        private final C context;

        public HandledContext(C context) {
            this.context = context;
        }

        @Override
        public void runWithHandler(EventHandler<C> handler) throws EventHandlerException {
            try {
                handler.handleEvent(this.context);
                Assert.assertTrue(AbstractStageQueueImpl.this.inflight.decrementAndGet() >= 0);
            }
            catch (Throwable throwable) {
                Assert.assertTrue(AbstractStageQueueImpl.this.inflight.decrementAndGet() >= 0);
                throw throwable;
            }
        }

        public boolean equals(Object obj) {
            if (this.context.getClass().isInstance(obj)) {
                return this.context.equals(obj);
            }
            return super.equals(obj);
        }
    }

    static class StageQueueStatsCollectorImpl
    extends StageQueueStatsCollector {
        private final AtomicInteger count = new AtomicInteger(0);
        private final String name;
        private final String trimmedName;

        public StageQueueStatsCollectorImpl(String stage) {
            this.trimmedName = stage.trim();
            this.name = this.makeWidth(stage, 40);
        }

        @Override
        public String getDetails() {
            return this.name + " : " + this.count;
        }

        @Override
        public void contextAdded() {
            this.count.incrementAndGet();
        }

        @Override
        public void contextRemoved() {
            this.count.decrementAndGet();
        }

        @Override
        public void reset() {
            this.count.set(0);
        }

        @Override
        public String getName() {
            return this.trimmedName;
        }

        @Override
        public int getDepth() {
            return this.count.get();
        }
    }

    static class NullStageQueueStatsCollector
    extends StageQueueStatsCollector {
        private final String name;
        private final String trimmedName;

        public NullStageQueueStatsCollector(String stage) {
            this.trimmedName = stage.trim();
            this.name = this.makeWidth(stage, 40);
        }

        @Override
        public String getDetails() {
            return this.name + " : Not Monitored";
        }

        @Override
        public void contextAdded() {
        }

        @Override
        public void contextRemoved() {
        }

        @Override
        public void reset() {
        }

        @Override
        public String getName() {
            return this.trimmedName;
        }

        @Override
        public int getDepth() {
            return -1;
        }
    }

    static abstract class StageQueueStatsCollector
    implements StageQueueStats {
        StageQueueStatsCollector() {
        }

        @Override
        public void logDetails(Logger statsLogger) {
            statsLogger.info(this.getDetails());
        }

        public abstract void contextAdded();

        public abstract void reset();

        public abstract void contextRemoved();

        protected String makeWidth(String name, int width) {
            int len = name.length();
            if (len == width) {
                return name;
            }
            if (len > width) {
                return name.substring(0, width);
            }
            StringBuffer buf = new StringBuffer(name);
            for (int i = len; i < width; ++i) {
                buf.append(' ');
            }
            return buf.toString();
        }
    }

    static interface SourceQueue<W>
    extends Source<W> {
        public StageQueueStatsCollector getStatsCollector();

        public void setStatsCollector(StageQueueStatsCollector var1);

        public int clear();

        @Override
        public boolean isEmpty();

        @Override
        public W poll(long var1) throws InterruptedException;

        public void put(W var1) throws InterruptedException;

        public int size();

        @Override
        public String getSourceName();
    }
}

