/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.config.schema.L2ConfigForL1;
import com.tc.net.core.ConnectionInfo;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInfoConfig {
    static Logger LOGGER = LoggerFactory.getLogger(ConnectionInfoConfig.class);
    private final ConnectionInfo[] connectionInfos;

    public ConnectionInfoConfig(L2ConfigForL1.L2Data[] l2sData) {
        this.connectionInfos = this.createValueFrom(l2sData);
    }

    private ConnectionInfo[] createValueFrom(L2ConfigForL1.L2Data[] l2sData) {
        ConnectionInfo[] out;
        String serversProperty = System.getProperty("tc.server");
        if (serversProperty != null && (serversProperty = serversProperty.trim()) != null && serversProperty.length() > 0) {
            LOGGER.info("tc.server: " + serversProperty);
            String[] serverDescs = serversProperty.split(",");
            int count = serverDescs.length;
            out = new ConnectionInfo[count];
            for (int i = 0; i < count; ++i) {
                String[] serverDesc = serverDescs[i].split(":");
                String host = serverDesc.length > 0 ? serverDesc[0] : "localhost";
                int tsaPort = 9410;
                if (serverDesc.length == 2) {
                    try {
                        tsaPort = Integer.parseInt(serverDesc[1]);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.info("Cannot parse port for tc.server element '" + serverDescs[i] + "'; Using default of 9410.");
                    }
                }
                out[i] = new ConnectionInfo(host, tsaPort);
            }
        } else {
            out = new ConnectionInfo[l2sData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = new ConnectionInfo(l2sData[i].host(), l2sData[i].tsaPort(), l2sData[i].getGroupId());
            }
        }
        return out;
    }

    public ConnectionInfo[] getConnectionInfos() {
        return this.connectionInfos;
    }

    public String toString() {
        return "ConnectionInfoConfig [connectionInfos=" + Arrays.toString(this.connectionInfos) + "]";
    }
}

