/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.terracotta.connection.client.TerracottaClientConfigParams;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;

abstract class AbstractConnectionService
implements ConnectionService {
    AbstractConnectionService() {
    }

    @Override
    public final Connection connect(URI uri, Properties properties) throws ConnectionException {
        String[] hosts;
        if (!this.handlesURI(uri)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        TerracottaClientConfigParams clientConfig = new TerracottaClientConfigParams();
        for (String host : hosts = uri.getSchemeSpecificPart().split(",")) {
            URI oneHost;
            if (0 != host.indexOf("//")) {
                host = "//" + host;
            }
            try {
                oneHost = new URI(host).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse uri " + uri, e);
            }
            String userInfo = oneHost.getUserInfo();
            String stripeUri = (null != userInfo ? userInfo + "@" : "") + oneHost.getHost() + ":" + oneHost.getPort();
            clientConfig.addStripeMemberUri(stripeUri);
        }
        clientConfig.addGenericProperties(properties);
        return this.internalConnect(clientConfig);
    }

    abstract Connection internalConnect(TerracottaClientConfigParams var1) throws ConnectionException;
}

