/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.ThreadUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class CallableWaiter {
    private static final int DEFAULT_CHECK_INTERVAL = 1000;
    private static final int DEFAULT_CALLABLE_TIMEOUT = 300000;

    public static void waitOnCallable(Callable<Boolean> callable) throws Exception {
        CallableWaiter.waitOnCallable(callable, 300000L);
    }

    public static void waitOnCallable(Callable<Boolean> callable, long timeoutMs) throws Exception {
        CallableWaiter.waitOnCallable(callable, timeoutMs, 1000);
    }

    public static void waitOnCallable(Callable<Boolean> callable, long timeoutMs, int interval) throws Exception {
        long start = System.nanoTime();
        while (!callable.call().booleanValue()) {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) >= timeoutMs) {
                throw new TCTimeoutException("Timed out waiting for callable after " + timeoutMs + "ms");
            }
            ThreadUtil.reallySleep(interval);
        }
    }
}

