/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.ClusterTierManagerCreationException;
import org.ehcache.clustered.client.internal.ClusterTierManagerNotFoundException;
import org.ehcache.clustered.client.internal.ClusterTierManagerValidationException;
import org.ehcache.clustered.client.internal.InternalClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.Timeouts;
import org.ehcache.clustered.client.internal.lock.VoltronReadWriteLock;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.InternalClusterTierClientEntity;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.DestroyInProgressException;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class ClusterTierManagerClientEntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagerClientEntityFactory.class);
    private final Connection connection;
    private final Map<String, VoltronReadWriteLock.Hold> maintenanceHolds = new ConcurrentHashMap<String, VoltronReadWriteLock.Hold>();
    private final Timeouts entityTimeouts;

    public ClusterTierManagerClientEntityFactory(Connection connection) {
        this(connection, Timeouts.builder().build());
    }

    public ClusterTierManagerClientEntityFactory(Connection connection, Timeouts entityTimeouts) {
        this.connection = connection;
        this.entityTimeouts = entityTimeouts;
    }

    public boolean acquireLeadership(String entityIdentifier) {
        VoltronReadWriteLock lock = this.createAccessLockFor(entityIdentifier);
        VoltronReadWriteLock.Hold hold = lock.tryWriteLock();
        if (hold == null) {
            return false;
        }
        this.maintenanceHolds.put(entityIdentifier, hold);
        return true;
    }

    public void abandonLeadership(String entityIdentifier) {
        VoltronReadWriteLock.Hold hold = this.maintenanceHolds.remove(entityIdentifier);
        if (hold == null) {
            throw new IllegalMonitorStateException("Leadership was never held");
        }
        hold.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String identifier, ServerSideConfiguration config) throws EntityAlreadyExistsException, ClusterTierManagerCreationException, EntityBusyException, TimeoutException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        VoltronReadWriteLock.Hold localMaintenance = null;
        if (existingMaintenance == null) {
            localMaintenance = this.createAccessLockFor(identifier).tryWriteLock();
        }
        if (existingMaintenance == null && localMaintenance == null) {
            throw new EntityBusyException("Unable to create cluster tier manager for id " + identifier + ": another client owns the maintenance lease");
        }
        boolean finished = false;
        try {
            EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration, Void> ref = this.getEntityRef(identifier);
            while (true) {
                block22: {
                    InternalClusterTierManagerClientEntity entity2;
                    block21: {
                        ref.create(new ClusterTierManagerConfiguration(identifier, config));
                        entity2 = ref.fetchEntity(null);
                        try {
                            entity2.setTimeouts(this.entityTimeouts);
                            finished = true;
                            if (!finished) break block21;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    if (finished) {
                                        entity2.close();
                                    } else {
                                        this.silentlyClose(entity2, identifier);
                                    }
                                    throw throwable;
                                }
                                catch (EntityNotFoundException entity2) {
                                }
                            }
                            catch (EntityConfigurationException e) {
                                throw new ClusterTierManagerCreationException("Unable to configure cluster tier manager for id " + identifier, e);
                            }
                            catch (EntityNotProvidedException | EntityVersionMismatchException e) {
                                LOGGER.error("Unable to create cluster tier manager for id {}", (Object)identifier, (Object)e);
                                throw new AssertionError((Object)e);
                            }
                            continue;
                        }
                        entity2.close();
                        break block22;
                    }
                    this.silentlyClose(entity2, identifier);
                }
                return;
                break;
            }
        }
        finally {
            if (localMaintenance != null) {
                if (finished) {
                    localMaintenance.unlock();
                } else {
                    this.silentlyUnlock(localMaintenance, identifier);
                }
            }
        }
    }

    public ClusterTierManagerClientEntity retrieve(String identifier, ServerSideConfiguration config) throws DestroyInProgressException, EntityNotFoundException, ClusterTierManagerValidationException, TimeoutException {
        InternalClusterTierManagerClientEntity entity;
        VoltronReadWriteLock.Hold fetchHold = this.createAccessLockFor(identifier).readLock();
        try {
            entity = this.getEntityRef(identifier).fetchEntity(null);
        }
        catch (EntityVersionMismatchException e) {
            LOGGER.error("Unable to retrieve cluster tier manager for id {}", (Object)identifier, (Object)e);
            this.silentlyUnlock(fetchHold, identifier);
            throw new AssertionError((Object)e);
        }
        entity.setTimeouts(this.entityTimeouts);
        boolean validated = false;
        try {
            entity.validate(config);
            validated = true;
            InternalClusterTierManagerClientEntity internalClusterTierManagerClientEntity = entity;
            return internalClusterTierManagerClientEntity;
        }
        catch (DestroyInProgressException e) {
            throw e;
        }
        catch (ClusterException e) {
            throw new ClusterTierManagerValidationException("Unable to validate cluster tier manager for id " + identifier, e);
        }
        finally {
            if (!validated) {
                this.silentlyClose(entity, identifier);
                this.silentlyUnlock(fetchHold, identifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String identifier) throws ClusterTierManagerNotFoundException, EntityBusyException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        VoltronReadWriteLock.Hold localMaintenance = null;
        if (existingMaintenance == null) {
            localMaintenance = this.createAccessLockFor(identifier).tryWriteLock();
        }
        if (existingMaintenance == null && localMaintenance == null) {
            throw new EntityBusyException("Destroy operation failed; " + identifier + " cluster tier's maintenance lease held");
        }
        boolean finished = false;
        try {
            EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration, Void> ref = this.getEntityRef(identifier);
            this.destroyAllClusterTiers(ref, identifier);
            try {
                if (!ref.destroy()) {
                    throw new EntityBusyException("Destroy operation failed; " + identifier + " cluster tier in use by other clients");
                }
                finished = true;
            }
            catch (EntityNotProvidedException e) {
                LOGGER.error("Unable to delete cluster tier manager for id {}", (Object)identifier, (Object)e);
                throw new AssertionError((Object)e);
            }
            catch (EntityNotFoundException e) {
            }
            catch (PermanentEntityException e) {
                LOGGER.error("Unable to destroy entity - server says it is permanent", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
        finally {
            if (localMaintenance != null) {
                if (finished) {
                    localMaintenance.unlock();
                } else {
                    this.silentlyUnlock(localMaintenance, identifier);
                }
            }
        }
    }

    private void destroyAllClusterTiers(EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration, Void> ref, String identifier) throws ClusterTierManagerNotFoundException {
        InternalClusterTierManagerClientEntity entity;
        try {
            entity = ref.fetchEntity(null);
        }
        catch (EntityNotFoundException e) {
            return;
        }
        catch (EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
        Set<String> storeIdentifiers = entity.prepareForDestroy();
        LOGGER.warn("Preparing to destroy stores {}", storeIdentifiers);
        for (String storeIdentifier : storeIdentifiers) {
            try {
                this.destroyClusteredStoreEntity(identifier, storeIdentifier);
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (CachePersistenceException e) {
                throw new AssertionError((Object)("Unable to destroy cluster tier - in use: " + e.getMessage()));
            }
        }
        entity.close();
    }

    private void silentlyClose(ClusterTierManagerClientEntity entity, String identifier) {
        try {
            entity.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close entity {}", (Object)identifier, (Object)e);
        }
    }

    private void silentlyUnlock(VoltronReadWriteLock.Hold localMaintenance, String identifier) {
        try {
            localMaintenance.unlock();
        }
        catch (Exception e) {
            LOGGER.error("Failed to unlock for id {}", (Object)identifier, (Object)e);
        }
    }

    private VoltronReadWriteLock createAccessLockFor(String entityIdentifier) {
        return new VoltronReadWriteLock(this.connection, "ClusterTierManagerClientEntityFactory-AccessLock-" + entityIdentifier);
    }

    private EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration, Void> getEntityRef(String identifier) {
        try {
            return this.connection.getEntityRef(InternalClusterTierManagerClientEntity.class, 10L, identifier);
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to get cluster tier manager for id {}", (Object)identifier, (Object)e);
            throw new AssertionError((Object)e);
        }
    }

    public ClusterTierClientEntity fetchOrCreateClusteredStoreEntity(String clusterTierManagerIdentifier, String storeIdentifier, ServerStoreConfiguration clientStoreConfiguration, boolean autoCreate) throws EntityNotFoundException, CachePersistenceException {
        EntityRef entityRef;
        try {
            entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        if (autoCreate) {
            while (true) {
                try {
                    entityRef.create(new ClusterTierEntityConfiguration(clusterTierManagerIdentifier, storeIdentifier, clientStoreConfiguration));
                }
                catch (EntityAlreadyExistsException e) {
                }
                catch (EntityConfigurationException e) {
                    throw new CachePersistenceException("Unable to create cluster tier", (Throwable)e);
                }
                catch (EntityException e) {
                    throw new AssertionError((Object)e);
                }
                try {
                    InternalClusterTierClientEntity entity = entityRef.fetchEntity(null);
                    entity.setStoreIdentifier(storeIdentifier);
                    entity.setTimeouts(this.entityTimeouts);
                    return entity;
                }
                catch (EntityNotFoundException entity) {
                    continue;
                }
                catch (EntityException e) {
                    throw new AssertionError((Object)e);
                }
                break;
            }
        }
        try {
            InternalClusterTierClientEntity entity = entityRef.fetchEntity(null);
            entity.setStoreIdentifier(storeIdentifier);
            entity.setTimeouts(this.entityTimeouts);
            return entity;
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (EntityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void destroyClusteredStoreEntity(String clusterTierManagerIdentifier, String storeIdentifier) throws EntityNotFoundException, CachePersistenceException {
        try {
            EntityRef entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
            if (!entityRef.destroy()) {
                throw new CachePersistenceException("Cannot destroy cluster tier '" + storeIdentifier + "': in use by other client(s)");
            }
        }
        catch (EntityNotProvidedException | PermanentEntityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String entityName(String clusterTierManagerIdentifier, String storeIdentifier) {
        return clusterTierManagerIdentifier + "$" + storeIdentifier;
    }
}

