/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.Sink;
import com.tc.async.api.Source;
import com.tc.async.impl.ContextWrapper;
import com.tc.async.impl.MultiStageQueueImpl;
import com.tc.async.impl.SingletonStageQueueImpl;
import com.tc.logging.TCLoggerProvider;
import com.tc.stats.Stats;
import com.tc.util.concurrent.QueueFactory;

public interface StageQueue<EC>
extends Sink<EC> {
    public static final StageQueueFactory FACTORY = new StageQueueFactory();

    public Source<ContextWrapper<EC>> getSource(int var1);

    @Override
    public void close();

    @Override
    public void addSingleThreaded(EC var1);

    @Override
    public void addMultiThreaded(EC var1);

    @Override
    public int size();

    public String toString();

    @Override
    public void clear();

    @Override
    public void enableStatsCollection(boolean var1);

    @Override
    public Stats getStats(long var1);

    @Override
    public Stats getStatsAndReset(long var1);

    @Override
    public boolean isStatsCollectionEnabled();

    @Override
    public void resetStats();

    public static class StageQueueFactory {
        public static <C> StageQueue<C> factory(int queueCount, QueueFactory<ContextWrapper<C>> queueFactory, TCLoggerProvider loggerProvider, String stageName, int queueSize) {
            if (queueCount == 1) {
                return new SingletonStageQueueImpl(queueFactory, loggerProvider, stageName, queueSize);
            }
            return new MultiStageQueueImpl(queueCount, queueFactory, loggerProvider, stageName, queueSize);
        }
    }
}

