/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntityFactory;
import org.ehcache.clustered.client.internal.ClusterTierManagerCreationException;
import org.ehcache.clustered.client.internal.ClusterTierManagerValidationException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.DestroyInProgressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.lease.connection.LeasedConnectionFactory;

class ConnectionState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionState.class);
    private static final String CONNECTION_PREFIX = "Ehcache:";
    private volatile Connection clusterConnection = null;
    private volatile ClusterTierManagerClientEntityFactory entityFactory = null;
    private volatile ClusterTierManagerClientEntity entity = null;
    private final ConcurrentMap<String, ClusterTierClientEntity> clusterTierEntities = new ConcurrentHashMap<String, ClusterTierClientEntity>();
    private final Timeouts timeouts;
    private final URI clusterUri;
    private final String entityIdentifier;
    private final Properties connectionProperties;
    private final ClusteringServiceConfiguration serviceConfiguration;

    ConnectionState(URI clusterUri, Timeouts timeouts, String entityIdentifier, Properties connectionProperties, ClusteringServiceConfiguration serviceConfiguration) {
        this.timeouts = timeouts;
        this.clusterUri = clusterUri;
        this.entityIdentifier = entityIdentifier;
        this.connectionProperties = connectionProperties;
        this.serviceConfiguration = serviceConfiguration;
    }

    public Connection getConnection() {
        return this.clusterConnection;
    }

    public ClusterTierClientEntity getClusterTierClientEntity(String cacheId) {
        return (ClusterTierClientEntity)this.clusterTierEntities.get(cacheId);
    }

    public ClusterTierManagerClientEntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public ClusterTierClientEntity createClusterTierClientEntity(String cacheId, ServerStoreConfiguration clientStoreConfiguration, boolean isReconnect) throws CachePersistenceException {
        ClusterTierClientEntity storeClientEntity;
        while (true) {
            try {
                storeClientEntity = isReconnect ? this.entityFactory.getClusterTierClientEntity(this.entityIdentifier, cacheId) : this.entityFactory.fetchOrCreateClusteredStoreEntity(this.entityIdentifier, cacheId, clientStoreConfiguration, this.serviceConfiguration.isAutoCreate());
                this.clusterTierEntities.put(cacheId, storeClientEntity);
            }
            catch (EntityNotFoundException e) {
                throw new CachePersistenceException("Cluster tier proxy '" + cacheId + "' for entity '" + this.entityIdentifier + "' does not exist.", (Throwable)e);
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                LOGGER.info("Disconnected to the server", (Throwable)e);
                this.handleConnectionClosedException();
                continue;
            }
            break;
        }
        return storeClientEntity;
    }

    public void removeClusterTierClientEntity(String cacheId) {
        this.clusterTierEntities.remove(cacheId);
    }

    public void initClusterConnection() {
        try {
            this.connectionProperties.put("connection.name", CONNECTION_PREFIX + this.entityIdentifier);
            this.connectionProperties.put("connection.timeout", Long.toString(this.timeouts.getConnectionTimeout().toMillis()));
            this.clusterConnection = LeasedConnectionFactory.connect(this.clusterUri, this.connectionProperties);
            this.entityFactory = new ClusterTierManagerClientEntityFactory(this.clusterConnection, this.timeouts);
        }
        catch (ConnectionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void closeConnection() {
        Connection conn = this.clusterConnection;
        this.clusterConnection = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing cluster connection: " + e);
            }
        }
    }

    private void silentDestroy() {
        LOGGER.debug("Found a broken ClusterTierManager - trying to clean it up");
        try {
            Thread.sleep(new Random().nextInt(1000));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EntityBusyException e) {
            LOGGER.debug("ClusterTierManager {} marked busy when trying to clean it up", (Object)this.entityIdentifier);
        }
    }

    public void acquireLeadership() {
        if (!this.entityFactory.acquireLeadership(this.entityIdentifier)) {
            this.entityFactory = null;
            this.closeConnection();
            throw new IllegalStateException("Couldn't acquire cluster-wide maintenance lease");
        }
    }

    public void initializeState() {
        try {
            if (this.serviceConfiguration.isAutoCreate()) {
                this.autoCreateEntity();
            } else {
                this.retrieveEntity();
            }
        }
        catch (RuntimeException e) {
            this.entityFactory = null;
            this.closeConnection();
            throw e;
        }
    }

    private void retrieveEntity() {
        try {
            this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
        }
        catch (DestroyInProgressException | EntityNotFoundException e) {
            throw new IllegalStateException("The cluster tier manager '" + this.entityIdentifier + "' does not exist. Please review your configuration.", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
        }
    }

    public void destroyState() {
        this.entityFactory = null;
        this.clusterTierEntities.clear();
        this.entity = null;
    }

    public void destroyAll() throws CachePersistenceException {
        LOGGER.info("destroyAll called for cluster tiers on {}", (Object)this.clusterUri);
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EntityBusyException e) {
            throw new CachePersistenceException("Can not delete cluster tiers on " + this.clusterUri, (Throwable)e);
        }
    }

    public void destroy(String name) throws CachePersistenceException {
        if (this.entity == null) {
            try {
                this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (TimeoutException e) {
                throw new CachePersistenceException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", (Throwable)e);
            }
            catch (DestroyInProgressException e) {
                this.silentDestroy();
                return;
            }
        }
        try {
            if (this.entity != null) {
                this.entityFactory.destroyClusteredStoreEntity(this.entityIdentifier, name);
            }
        }
        catch (EntityNotFoundException e) {
            LOGGER.debug("Destruction of cluster tier {} failed as it does not exist", (Object)name);
        }
    }

    private void autoCreateEntity() throws ClusterTierManagerValidationException, IllegalStateException {
        while (true) {
            try {
                this.entityFactory.create(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
            }
            catch (ClusterTierManagerCreationException e) {
                throw new IllegalStateException("Could not create the cluster tier manager '" + this.entityIdentifier + "'.", e);
            }
            catch (EntityBusyException | EntityAlreadyExistsException e) {
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                LOGGER.info("Disconnected to the server", (Throwable)e);
                this.initClusterConnection();
                continue;
            }
            try {
                this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
            }
            catch (DestroyInProgressException e) {
                this.silentDestroy();
                continue;
            }
            catch (EntityNotFoundException e) {
                continue;
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                LOGGER.info("Disconnected to the server", (Throwable)e);
                this.initClusterConnection();
                continue;
            }
            break;
        }
    }

    private void handleConnectionClosedException() {
        try {
            this.destroyState();
            this.initClusterConnection();
            this.retrieveEntity();
        }
        catch (ConnectionClosedException | ConnectionShutdownException e) {
            LOGGER.info("Disconnected to the server", (Throwable)e);
            this.handleConnectionClosedException();
        }
    }
}

