/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonServerStoreProxy.class);
    private final String cacheId;
    private final ClusterTierClientEntity entity;

    CommonServerStoreProxy(String cacheId, ClusterTierClientEntity entity, ServerStoreProxy.ServerCallback invalidation) {
        this.cacheId = Objects.requireNonNull(cacheId, "Cache-ID must be non-null");
        this.entity = Objects.requireNonNull(entity, "ClusterTierClientEntity must be non-null");
        Objects.requireNonNull(invalidation, "ServerCallback must be non-null");
        entity.addResponseListener(EhcacheEntityResponse.ServerInvalidateHash.class, response -> {
            long key = response.getKey();
            LOGGER.debug("CLIENT: on cache {}, server requesting hash {} to be invalidated", (Object)cacheId, (Object)key);
            invalidation.onInvalidateHash(key);
        });
        entity.addResponseListener(EhcacheEntityResponse.ClientInvalidateHash.class, response -> {
            long key = response.getKey();
            int invalidationId = response.getInvalidationId();
            LOGGER.debug("CLIENT: doing work to invalidate hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
            invalidation.onInvalidateHash(key);
            try {
                LOGGER.debug("CLIENT: ack'ing invalidation of hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                entity.invokeAndWaitForSend(new ServerStoreOpMessage.ClientInvalidationAck(key, invalidationId), false);
            }
            catch (Exception e) {
                LOGGER.error("error acking client invalidation of hash {} on cache {}", new Object[]{key, cacheId, e});
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.ClientInvalidateAll.class, response -> {
            int invalidationId = response.getInvalidationId();
            LOGGER.debug("CLIENT: doing work to invalidate all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
            invalidation.onInvalidateAll();
            try {
                LOGGER.debug("CLIENT: ack'ing invalidation of all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                entity.invokeAndWaitForSend(new ServerStoreOpMessage.ClientInvalidationAllAck(invalidationId), false);
            }
            catch (Exception e) {
                LOGGER.error("error acking client invalidation of all on cache {}", (Object)cacheId, (Object)e);
            }
        });
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    <T extends EhcacheEntityResponse> void addResponseListener(Class<T> listenerClass, ClusterTierClientEntity.ResponseListener<T> listener) {
        this.entity.addResponseListener(listenerClass, listener);
    }

    @Override
    public void close() {
        this.entity.close();
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invokeAndWaitForComplete(new ServerStoreOpMessage.GetMessage(key), false);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getResponseType() == EhcacheResponseType.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for get operation was invalid : " + (response != null ? response.getResponseType() : "null message"));
    }

    @Override
    public void append(long key, ByteBuffer payLoad) {
        try {
            this.entity.invokeAndWaitForReceive(new ServerStoreOpMessage.AppendMessage(key, payLoad), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invokeAndWaitForRetired(new ServerStoreOpMessage.GetAndAppendMessage(key, payLoad), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getResponseType() == EhcacheResponseType.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for getAndAppend operation was invalid : " + (response != null ? response.getResponseType() : "null message"));
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.entity.invokeAndWaitForSend(new ServerStoreOpMessage.ReplaceAtHeadMessage(key, expect, update), false);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public void clear() throws TimeoutException {
        try {
            this.entity.invokeAndWaitForRetired(new ServerStoreOpMessage.ClearMessage(), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }
}

