/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.internal.InternalClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.Timeouts;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.InvalidClientIdException;
import org.ehcache.clustered.common.internal.messages.ClusterTierManagerReconnectMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageFactory;
import org.ehcache.clustered.common.internal.messages.ReconnectMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class SimpleClusterTierManagerClientEntity
implements InternalClusterTierManagerClientEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleClusterTierManagerClientEntity.class);
    private final AtomicLong sequenceGenerator = new AtomicLong(0L);
    private final ReconnectMessageCodec reconnectMessageCodec = new ReconnectMessageCodec();
    private final EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint;
    private final LifeCycleMessageFactory messageFactory;
    private volatile UUID clientId;
    private Timeouts timeouts = Timeouts.builder().build();

    public SimpleClusterTierManagerClientEntity(EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint) {
        this.endpoint = endpoint;
        this.messageFactory = new LifeCycleMessageFactory();
        endpoint.setDelegate(new EndpointDelegate<EhcacheEntityResponse>(){

            @Override
            public void handleMessage(EhcacheEntityResponse messageFromServer) {
            }

            @Override
            public byte[] createExtendedReconnectData() {
                ClusterTierManagerReconnectMessage reconnectMessage = new ClusterTierManagerReconnectMessage(SimpleClusterTierManagerClientEntity.this.clientId);
                return SimpleClusterTierManagerClientEntity.this.reconnectMessageCodec.encode(reconnectMessage);
            }

            @Override
            public void didDisconnectUnexpectedly() {
            }
        });
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    @Override
    public UUID getClientId() {
        if (this.clientId == null) {
            throw new IllegalStateException("Client Id cannot be null");
        }
        return this.clientId;
    }

    @Override
    public void setClientId(UUID clientId) {
        this.clientId = clientId;
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    @Override
    public void validate(ServerSideConfiguration config) throws ClusterException, TimeoutException {
        boolean clientIdGenerated = false;
        while (true) {
            try {
                if (clientIdGenerated || this.clientId == null) {
                    this.clientId = UUID.randomUUID();
                    clientIdGenerated = true;
                }
                this.messageFactory.setClientId(this.clientId);
                this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.validateStoreManager(config), false);
                return;
            }
            catch (InvalidClientIdException e) {
                if (clientIdGenerated) continue;
                throw new AssertionError((Object)("Injected ClientID refused by server - " + this.clientId));
            }
            break;
        }
    }

    @Override
    public Set<String> prepareForDestroy() {
        try {
            EhcacheEntityResponse.PrepareForDestroy response = (EhcacheEntityResponse.PrepareForDestroy)this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.prepareForDestroy(), true);
            return response.getStores();
        }
        catch (TimeoutException | ClusterException exception) {
            return null;
        }
    }

    private EhcacheEntityResponse invokeInternal(TimeoutDuration timeLimit, EhcacheEntityMessage message, boolean replicate) throws ClusterException, TimeoutException {
        try {
            EhcacheEntityResponse response = SimpleClusterTierManagerClientEntity.waitFor(timeLimit, this.invokeAsync(message, replicate));
            if (EhcacheResponseType.FAILURE.equals((Object)response.getResponseType())) {
                throw ((EhcacheEntityResponse.Failure)response).getCause();
            }
            return response;
        }
        catch (MessageCodecException | EntityException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
        catch (TimeoutException e) {
            String msg = "Timeout exceeded for " + message + " message; " + timeLimit;
            TimeoutException timeoutException = new TimeoutException(msg);
            timeoutException.initCause(e);
            LOGGER.info(msg, (Throwable)timeoutException);
            throw timeoutException;
        }
    }

    private InvokeFuture<EhcacheEntityResponse> invokeAsync(EhcacheEntityMessage message, boolean replicate) throws MessageCodecException {
        this.getClientId();
        if (replicate) {
            message.setId(this.sequenceGenerator.getAndIncrement());
        }
        return this.endpoint.beginInvoke().message(message).replicate(replicate).invoke();
    }

    private static <T extends EntityResponse> T waitFor(TimeoutDuration timeLimit, InvokeFuture<T> future) throws EntityException, TimeoutException {
        boolean interrupted = false;
        long deadlineTimeout = System.nanoTime() + timeLimit.toNanos();
        while (true) {
            try {
                long timeRemaining = deadlineTimeout - System.nanoTime();
                T t = future.getWithTimeout(timeRemaining, TimeUnit.NANOSECONDS);
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

