/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.terracotta.connection.TerracottaConnection;
import com.terracotta.connection.URLConfigUtil;
import com.terracotta.connection.client.TerracottaClientConfigParams;
import com.terracotta.connection.client.TerracottaClientStripeConnectionConfig;
import com.terracotta.diagnostic.DiagnosticClientImpl;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;

public class DiagnosticConnectionService
implements ConnectionService {
    private static final String SCHEME = "diagnostic";

    @Override
    public boolean handlesURI(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    @Override
    public Connection connect(URI uri, Properties properties) throws ConnectionException {
        if (!this.handlesURI(uri)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        TerracottaClientConfigParams clientConfig = new TerracottaClientConfigParams();
        clientConfig.addStripeMemberUri(uri.getHost() + ":" + uri.getPort());
        clientConfig.addGenericProperties(properties);
        TerracottaClientStripeConnectionConfig stripeConnectionConfig = new TerracottaClientStripeConnectionConfig();
        for (String memberUri : clientConfig.getStripeMemberUris()) {
            String expandedMemberUri = URLConfigUtil.translateSystemProperties(memberUri);
            stripeConnectionConfig.addStripeMemberUri(expandedMemberUri);
        }
        final DiagnosticClientImpl client = new DiagnosticClientImpl(stripeConnectionConfig, properties);
        try {
            client.init();
        }
        catch (TimeoutException exp) {
            throw new ConnectionException(exp);
        }
        catch (ConfigurationSetupException config) {
            throw new ConnectionException(config);
        }
        catch (InterruptedException ie) {
            throw new ConnectionException(ie);
        }
        catch (Throwable t) {
            throw new ConnectionException(t);
        }
        return new TerracottaConnection(client.getClientEntityManager(), new Runnable(){

            @Override
            public void run() {
                client.shutdown();
            }
        });
    }
}

