/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.concurrent.SetOnceFlag;
import java.util.ArrayList;
import java.util.List;

public class CommonShutDownHook
implements Runnable {
    private static final SetOnceFlag run = new SetOnceFlag();
    private static final List<Runnable> runnables = new ArrayList<Runnable>();
    private static Thread hooker;
    private static boolean shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        List<Runnable> list = runnables;
        synchronized (list) {
            if (shutdown) {
                return;
            }
            shutdown = true;
            CommonShutDownHook.runHooks();
            if (hooker != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(hooker);
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    hooker = null;
                    runnables.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(Runnable r) {
        if (r == null) {
            throw new NullPointerException("Shutdown hook cannot be null");
        }
        List<Runnable> list = runnables;
        synchronized (list) {
            if (shutdown) {
                throw new IllegalStateException("shutdown");
            }
            runnables.add(r);
            if (hooker == null) {
                hooker = new Thread((Runnable)new CommonShutDownHook(), "CommonShutDownHook");
                hooker.setDaemon(true);
                Runtime.getRuntime().addShutdownHook(hooker);
            }
        }
    }

    @Override
    public void run() {
        CommonShutDownHook.runHooks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runHooks() {
        Runnable[] hooks;
        if (!run.attemptSet()) {
            return;
        }
        List<Runnable> list = runnables;
        synchronized (list) {
            hooks = runnables.toArray(new Runnable[runnables.size()]);
        }
        for (Runnable r : hooks) {
            try {
                r.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

