/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.delivery.OOOProtocolMessage;
import com.tc.net.protocol.delivery.OOOProtocolMessageDelivery;
import com.tc.net.protocol.delivery.ReceiveStateMachine;
import com.tc.net.protocol.delivery.SendStateMachine;
import com.tc.properties.ReconnectConfig;
import com.tc.util.Assert;
import com.tc.util.Util;

class GuaranteedDeliveryProtocol {
    private final SendStateMachine sender;
    private final ReceiveStateMachine receiver;

    public GuaranteedDeliveryProtocol(OOOProtocolMessageDelivery delivery, ReconnectConfig reconnectConfig, boolean isClient) {
        this.sender = new SendStateMachine(delivery, reconnectConfig, isClient);
        this.receiver = new ReceiveStateMachine(delivery, reconnectConfig, isClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TCNetworkMessage message) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.sender.put(message);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            this.sender.execute(null);
        }
        finally {
            Util.selfInterruptIfNeeded(interrupted);
        }
    }

    public void receive(OOOProtocolMessage msg) {
        if (msg.isSend()) {
            this.sender.execute(msg);
            this.receiver.execute(msg);
        } else if (msg.isAck() || msg.isHandshakeReplyOk()) {
            this.sender.execute(msg);
        } else {
            Assert.eval("Unexpected OOO Msg: " + msg, false);
        }
    }

    public synchronized void start() {
        this.sender.start();
        this.receiver.start();
    }

    public synchronized void pause() {
        if (!this.sender.isPaused()) {
            this.sender.pause();
        }
        if (!this.receiver.isPaused()) {
            this.receiver.pause();
        }
    }

    public synchronized boolean isPaused() {
        return this.sender.isPaused() && this.receiver.isPaused();
    }

    public synchronized void resume() {
        this.sender.resume();
        this.receiver.resume();
    }

    public synchronized void reset() {
        this.sender.reset();
        this.receiver.reset();
    }

    public ReceiveStateMachine getReceiver() {
        return this.receiver;
    }

    public SendStateMachine getSender() {
        return this.sender;
    }

    public String toString() {
        return "SendStateMachine: " + this.sender + "; ReceiveStateMachine: " + this.receiver;
    }
}

