/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core.event;

import com.tc.logging.TCLogger;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.List;

public class TCConnectionEventCaller {
    private static final int CONNECT = 1;
    private static final int EOF = 2;
    private static final int ERROR = 3;
    private static final int CLOSE = 4;
    private final SetOnceFlag connectEvent = new SetOnceFlag();
    private final SetOnceFlag eofEvent = new SetOnceFlag();
    private final SetOnceFlag errorEvent = new SetOnceFlag();
    private final SetOnceFlag closeEvent = new SetOnceFlag();
    private final TCLogger logger;

    public TCConnectionEventCaller(TCLogger logger) {
        this.logger = logger;
    }

    public void fireErrorEvent(List<TCConnectionEventListener> eventListeners, TCConnection conn, Exception exception, TCNetworkMessage context) {
        if (this.errorEvent.attemptSet()) {
            TCConnectionErrorEvent event = new TCConnectionErrorEvent(conn, exception, context);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 3);
        }
    }

    public void fireConnectEvent(List<TCConnectionEventListener> eventListeners, TCConnection conn) {
        if (this.connectEvent.attemptSet()) {
            TCConnectionEvent event = new TCConnectionEvent(conn);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 1);
        }
    }

    public void fireEndOfFileEvent(List<TCConnectionEventListener> eventListeners, TCConnection conn) {
        if (this.eofEvent.attemptSet()) {
            TCConnectionEvent event = new TCConnectionEvent(conn);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 2);
        }
    }

    public void fireCloseEvent(List<TCConnectionEventListener> eventListeners, TCConnection conn) {
        if (this.closeEvent.attemptSet()) {
            TCConnectionEvent event = new TCConnectionEvent(conn);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 4);
        }
    }

    private static void fireEvent(List<TCConnectionEventListener> eventListeners, TCConnectionEvent event, TCLogger logger, int type) {
        for (TCConnectionEventListener listener : eventListeners) {
            try {
                switch (type) {
                    case 1: {
                        listener.connectEvent(event);
                        break;
                    }
                    case 2: {
                        listener.endOfFileEvent(event);
                        break;
                    }
                    case 3: {
                        listener.errorEvent((TCConnectionErrorEvent)event);
                        break;
                    }
                    case 4: {
                        listener.closeEvent(event);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown event type: " + type));
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unhandled exception in event handler", e);
                throw new RuntimeException(e);
            }
        }
    }
}

