/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.TerracottaInternalClientFactory;
import com.terracotta.connection.TerracottaInternalClientImpl;
import com.terracotta.connection.URLConfigUtil;
import com.terracotta.connection.client.TerracottaClientConfigParams;
import com.terracotta.connection.client.TerracottaClientStripeConnectionConfig;
import java.util.Properties;

public class TerracottaInternalClientFactoryImpl
implements TerracottaInternalClientFactory {
    public static final String SECRET_PROVIDER = "com.terracotta.express.SecretProvider";

    public TerracottaInternalClientFactoryImpl() {
        TerracottaInternalClientFactoryImpl.testForWrongTcconfig();
        System.setProperty("tc.active", "true");
        System.setProperty("tc.dso.globalmode", "false");
    }

    @Override
    public TerracottaInternalClient createL1Client(TerracottaClientConfigParams config) {
        TerracottaClientStripeConnectionConfig stripeConnectionConfig = new TerracottaClientStripeConnectionConfig();
        for (String memberUri : config.getStripeMemberUris()) {
            String expandedMemberUri = URLConfigUtil.translateSystemProperties(memberUri);
            stripeConnectionConfig.addStripeMemberUri(expandedMemberUri);
        }
        return this.createClient(stripeConnectionConfig, config.getProductId(), config.getGenericProperties());
    }

    private TerracottaInternalClient createClient(TerracottaClientStripeConnectionConfig stripeConnectionConfig, String productId, Properties props) {
        TerracottaInternalClientImpl client = new TerracottaInternalClientImpl(stripeConnectionConfig, productId, props);
        return client;
    }

    private static void testForWrongTcconfig() {
        String tcConfigValue = System.getProperty("tc.config");
        if (tcConfigValue != null) {
            throw new RuntimeException("The Terracotta config file should not be set through -Dtc.config in this usage.");
        }
    }
}

