/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.util.Assert;

public interface L2ConfigForL1 {
    public L2Data[] l2Data();

    public static class L2Data {
        private final String host;
        private final int tsaPort;
        private int groupId = -1;
        private final boolean secure;

        public L2Data(String host, int tsaPort) {
            this(host, tsaPort, false);
        }

        public L2Data(String host, int tsaPort, boolean secure) {
            Assert.assertNotBlank(host);
            this.host = host;
            this.tsaPort = tsaPort < 0 ? 9410 : tsaPort;
            this.secure = secure;
        }

        public String host() {
            return this.host;
        }

        public int tsaPort() {
            return this.tsaPort;
        }

        public boolean secure() {
            return this.secure;
        }

        public void setGroupId(int gid) {
            Assert.assertTrue(gid >= 0);
            this.groupId = gid;
        }

        public int getGroupId() {
            Assert.assertTrue(this.groupId > -1);
            return this.groupId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.groupId;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.tsaPort;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            L2Data other = (L2Data)obj;
            if (this.groupId != other.groupId) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.tsaPort == other.tsaPort;
        }

        public String toString() {
            return "L2Data [host=" + this.host + ", tsaPort=" + this.tsaPort + "]";
        }
    }
}

