/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.management;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class TCSerializableCollection<T extends TCSerializable<T>>
extends AbstractCollection<T>
implements TCSerializable<TCSerializableCollection<T>> {
    private final Set<T> authority = new HashSet<T>();

    public Set<T> getAuthority() {
        return Collections.unmodifiableSet(this.authority);
    }

    @Override
    public boolean add(T t) {
        return this.authority.add(t);
    }

    @Override
    public Iterator<T> iterator() {
        return this.authority.iterator();
    }

    @Override
    public int size() {
        return this.authority.size();
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeInt(this.authority.size());
        for (TCSerializable t : this.authority) {
            t.serializeTo(serialOutput);
        }
    }

    @Override
    public TCSerializableCollection<T> deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.clear();
        int count = serialInput.readInt();
        for (int i = 0; i < count; ++i) {
            this.add((T)((TCSerializable)this.newObject().deserializeFrom(serialInput)));
        }
        return this;
    }

    protected abstract T newObject();
}

