/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.MultiThreadedEventContext;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.TCMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HydrateHandler
extends AbstractEventHandler<HydrateContext> {
    private static Logger logger = LoggerFactory.getLogger(HydrateHandler.class);

    @Override
    public void handleEvent(HydrateContext hc) {
        TCMessage message = hc.getMessage();
        try {
            message.hydrate();
        }
        catch (Throwable t) {
            try {
                logger.error("Error hydrating message of type " + message.getMessageType(), t);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            message.getChannel().close();
            return;
        }
        if (message instanceof MultiThreadedEventContext) {
            hc.getDestSink().addMultiThreaded(message);
        } else {
            hc.getDestSink().addSingleThreaded(message);
        }
    }
}

