/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import com.tc.net.util.TSASSLSocketFactory;
import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.server.RMIClientSocketFactory;
import java.text.MessageFormat;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;

public class JMXConnectorProxy
implements JMXConnector {
    private final String m_host;
    private final int m_port;
    private final Map<String, Object> m_env;
    private JMXServiceURL m_serviceURL;
    private JMXConnector m_connector;
    private final JMXConnector m_connectorProxy;
    private final boolean m_secured;
    public static final String JMXMP_URI_PATTERN = "service:jmx:jmxmp://{0}:{1}";
    public static final String JMXRMI_URI_PATTERN = "service:jmx:rmi:///jndi/rmi://{0}:{1}/jmxrmi";

    public JMXConnectorProxy(String host, int port, Map<String, Object> env) {
        this(host, port, env, false);
    }

    public JMXConnectorProxy(String host, int port, Map<String, Object> env, boolean secured) {
        this.m_host = host;
        this.m_port = port;
        this.m_env = env;
        this.m_connectorProxy = this.getConnectorProxy();
        this.m_secured = secured;
    }

    public JMXConnectorProxy(String host, int port) {
        this(host, port, null, false);
    }

    private JMXConnector getConnectorProxy() {
        JMXConnector connector = (JMXConnector)Proxy.newProxyInstance(JMXConnector.class.getClassLoader(), new Class[]{JMXConnector.class}, (InvocationHandler)new ConnectorInvocationHandler());
        return connector;
    }

    static boolean isConnectException(IOException ioe) {
        for (Throwable t = ioe; t != null; t = t.getCause()) {
            if (!(t instanceof ConnectException)) continue;
            return true;
        }
        return false;
    }

    static boolean isAuthenticationException(IOException ioe) {
        for (Throwable t = ioe; t != null; t = t.getCause()) {
            String detailMessage;
            if (!(t instanceof NotSerializableException) || !"com.sun.jndi.ldap.LdapCtx".equals(detailMessage = t.getMessage())) continue;
            return true;
        }
        return false;
    }

    private void determineConnector() throws Exception {
        JMXServiceURL url = new JMXServiceURL(JMXConnectorProxy.getSecureJMXConnectorURL(this.m_host, this.m_port));
        if (this.m_secured) {
            RMIClientSocketFactory csf = Boolean.getBoolean("tc.ssl.trustAllCerts") ? new TSASSLSocketFactory() : new SslRMIClientSocketFactory();
            SslRMIServerSocketFactory ssf = new SslRMIServerSocketFactory();
            this.m_env.put("jmx.remote.rmi.client.socket.factory", csf);
            this.m_env.put("jmx.remote.rmi.server.socket.factory", ssf);
            this.m_env.put("com.sun.jndi.rmi.factory.socket", csf);
            this.m_serviceURL = new JMXServiceURL("service:jmx:rmi://" + this.m_host + ":" + this.m_port + "/jndi/rmi://" + this.m_host + ":" + this.m_port + "/jmxrmi");
            this.m_connector = JMXConnectorFactory.connect(url, this.m_env);
        } else {
            try {
                this.m_connector = JMXConnectorFactory.connect(url, this.m_env);
                this.m_serviceURL = url;
            }
            catch (IOException ioe) {
                if (JMXConnectorProxy.isConnectException(ioe)) {
                    throw ioe;
                }
                if (JMXConnectorProxy.isAuthenticationException(ioe)) {
                    throw new SecurityException("Invalid login name or credentials");
                }
                url = new JMXServiceURL(JMXConnectorProxy.getJMXConnectorURL(this.m_host, this.m_port));
                this.m_connector = JMXConnectorFactory.connect(url, this.m_env);
                this.m_serviceURL = url;
            }
        }
    }

    private void ensureConnector() throws Exception {
        if (this.m_connector == null) {
            this.determineConnector();
        }
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public JMXServiceURL getServiceURL() {
        return this.m_serviceURL;
    }

    public static String getJMXConnectorURL(String host, int port) {
        return MessageFormat.format(JMXMP_URI_PATTERN, host, port + "");
    }

    public static String getSecureJMXConnectorURL(String host, int port) {
        return MessageFormat.format(JMXRMI_URI_PATTERN, host, port + "");
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object data) {
        this.m_connectorProxy.addConnectionNotificationListener(listener, filter, data);
    }

    @Override
    public void close() throws IOException {
        this.m_connectorProxy.close();
    }

    @Override
    public void connect() throws IOException {
        this.m_connectorProxy.connect();
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException {
        this.m_connectorProxy.connect(env);
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.m_connectorProxy.getConnectionId();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.m_connectorProxy.getMBeanServerConnection();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        return this.m_connectorProxy.getMBeanServerConnection(subject);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.m_connectorProxy.removeConnectionNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object data) throws ListenerNotFoundException {
        this.m_connectorProxy.removeConnectionNotificationListener(listener, filter, data);
    }

    public String toString() {
        return this.m_host + ":" + this.m_port;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    class ConnectorInvocationHandler
    implements InvocationHandler {
        ConnectorInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close") && JMXConnectorProxy.this.m_connector == null) {
                return null;
            }
            JMXConnectorProxy.this.ensureConnector();
            try {
                Class<?> c = JMXConnectorProxy.this.m_connector.getClass();
                Method m = c.getMethod(method.getName(), method.getParameterTypes());
                return m.invoke((Object)JMXConnectorProxy.this.m_connector, args);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw ite;
            }
        }
    }
}

