/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.GroupMessage;
import com.tc.net.groups.MessageID;
import com.tc.net.protocol.tcm.TCMessageImpl;
import java.io.IOException;

public abstract class AbstractGroupMessage
implements GroupMessage {
    private static long nextID = 0L;
    private int type;
    private MessageID id;
    private MessageID requestID;
    private transient NodeID messageOrginator = ServerID.NULL_ID;

    protected AbstractGroupMessage(int type) {
        this.type = type;
        this.id = AbstractGroupMessage.getNextID();
        this.requestID = MessageID.NULL_ID;
    }

    protected AbstractGroupMessage(int type, MessageID requestID) {
        this.type = type;
        this.id = AbstractGroupMessage.getNextID();
        this.requestID = requestID;
    }

    @Override
    public final void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeInt(this.type);
        serialOutput.writeLong(this.id.toLong());
        serialOutput.writeLong(this.requestID.toLong());
        this.basicSerializeTo(serialOutput);
    }

    @Override
    public final GroupMessage deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.type = serialInput.readInt();
        this.id = new MessageID(serialInput.readLong());
        this.requestID = new MessageID(serialInput.readLong());
        this.basicDeserializeFrom(serialInput);
        return this;
    }

    protected abstract void basicDeserializeFrom(TCByteBufferInput var1) throws IOException;

    protected abstract void basicSerializeTo(TCByteBufferOutput var1);

    @Override
    public boolean isRecycleOnRead(TCMessageImpl message) {
        return true;
    }

    private static final synchronized MessageID getNextID() {
        return new MessageID(nextID++);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public MessageID getMessageID() {
        return this.id;
    }

    @Override
    public MessageID inResponseTo() {
        return this.requestID;
    }

    @Override
    public void setMessageOrginator(NodeID n) {
        this.messageOrginator = n;
    }

    @Override
    public NodeID messageFrom() {
        return this.messageOrginator;
    }
}

