/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.ServerEntityMessage;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ClientInstanceID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;

public class ServerEntityMessageImpl
extends DSOMessageBase
implements ServerEntityMessage {
    private static final byte ENTITY_DESCRIPTOR = 0;
    private static final byte MESSAGE = 1;
    private static final byte RESPONSE_ID = 2;
    private byte[] message;
    private ClientInstanceID clientInstance;
    private Long responseId;

    public ServerEntityMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public ServerEntityMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void setMessage(ClientInstanceID clientInstance, byte[] message) {
        this.clientInstance = clientInstance;
        this.message = message;
    }

    @Override
    public void setMessage(ClientInstanceID clientInstance, byte[] payload, long responseId) {
        this.clientInstance = clientInstance;
        this.message = payload;
        this.responseId = responseId;
    }

    @Override
    public Long getResponseId() {
        return this.responseId;
    }

    @Override
    public ClientInstanceID getClientInstanceID() {
        return this.clientInstance;
    }

    @Override
    public byte[] getMessage() {
        return this.message;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.clientInstance);
        if (this.responseId != null) {
            this.putNVPair((byte)2, this.responseId);
        }
        this.putNVPair((byte)1, this.message.length);
        this.getOutputStream().write(this.message);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        boolean didMatch = false;
        switch (name) {
            case 0: {
                this.clientInstance = ClientInstanceID.readFrom(this.getInputStream());
                didMatch = true;
                break;
            }
            case 1: {
                this.message = this.getBytesArray();
                didMatch = true;
                break;
            }
            case 2: {
                this.responseId = this.getLongValue();
                didMatch = true;
                break;
            }
            default: {
                didMatch = false;
            }
        }
        return didMatch;
    }
}

