/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.net.URI;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.internal.Timeouts;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.core.HumanReadable;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class ClusteringServiceConfiguration
implements ServiceCreationConfiguration<ClusteringService>,
CacheManagerConfiguration<PersistentCacheManager>,
HumanReadable {
    private final URI clusterUri;
    private final boolean autoCreate;
    private final ServerSideConfiguration serverConfiguration;
    private final TimeoutDuration readOperationTimeout;

    public ClusteringServiceConfiguration(URI clusterUri) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        this.clusterUri = clusterUri;
        this.autoCreate = false;
        this.serverConfiguration = null;
        this.readOperationTimeout = Timeouts.DEFAULT_READ_OPERATION_TIMEOUT;
    }

    public ClusteringServiceConfiguration(URI clusterUri, TimeoutDuration readOperationTimeout) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        this.validateReadOperationTimeout(readOperationTimeout);
        this.clusterUri = clusterUri;
        this.autoCreate = false;
        this.serverConfiguration = null;
        this.readOperationTimeout = readOperationTimeout;
    }

    public ClusteringServiceConfiguration(URI clusterUri, ServerSideConfiguration serverConfig) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        if (serverConfig == null) {
            throw new NullPointerException("Server configuration cannot be null");
        }
        this.clusterUri = clusterUri;
        this.autoCreate = false;
        this.serverConfiguration = serverConfig;
        this.readOperationTimeout = Timeouts.DEFAULT_READ_OPERATION_TIMEOUT;
    }

    public ClusteringServiceConfiguration(URI clusterUri, TimeoutDuration readOperationTimeout, ServerSideConfiguration serverConfig) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        this.validateReadOperationTimeout(readOperationTimeout);
        if (serverConfig == null) {
            throw new NullPointerException("Server configuration cannot be null");
        }
        this.clusterUri = clusterUri;
        this.autoCreate = false;
        this.serverConfiguration = serverConfig;
        this.readOperationTimeout = readOperationTimeout;
    }

    public ClusteringServiceConfiguration(URI clusterUri, boolean autoCreate, ServerSideConfiguration serverConfig) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        if (serverConfig == null) {
            throw new NullPointerException("Server configuration cannot be null");
        }
        this.clusterUri = clusterUri;
        this.autoCreate = autoCreate;
        this.serverConfiguration = serverConfig;
        this.readOperationTimeout = Timeouts.DEFAULT_READ_OPERATION_TIMEOUT;
    }

    public ClusteringServiceConfiguration(URI clusterUri, TimeoutDuration readOperationTimeout, boolean autoCreate, ServerSideConfiguration serverConfig) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        this.validateReadOperationTimeout(readOperationTimeout);
        if (serverConfig == null) {
            throw new NullPointerException("Server configuration cannot be null");
        }
        this.clusterUri = clusterUri;
        this.autoCreate = autoCreate;
        this.serverConfiguration = serverConfig;
        this.readOperationTimeout = readOperationTimeout;
    }

    protected ClusteringServiceConfiguration(ClusteringServiceConfiguration baseConfig) {
        if (baseConfig == null) {
            throw new NullPointerException("Base configuration cannot be null");
        }
        this.clusterUri = baseConfig.getClusterUri();
        this.readOperationTimeout = baseConfig.getReadOperationTimeout();
        this.autoCreate = baseConfig.isAutoCreate();
        this.serverConfiguration = baseConfig.getServerConfiguration();
    }

    private static void validateClusterUri(URI clusterUri) {
        if (clusterUri == null) {
            throw new NullPointerException("Cluster URI cannot be null.");
        }
    }

    private void validateReadOperationTimeout(TimeoutDuration readOperationTimeout) {
        if (readOperationTimeout == null) {
            throw new NullPointerException("readOperationTimeout cannot be null");
        }
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public ServerSideConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public TimeoutDuration getReadOperationTimeout() {
        return this.readOperationTimeout;
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    public CacheManagerBuilder<PersistentCacheManager> builder(CacheManagerBuilder<? extends CacheManager> other) {
        return other.using((ServiceCreationConfiguration)this);
    }

    public String readableString() {
        return this.getClass().getName() + ":\n    " + "clusterUri: " + this.getClusterUri() + "\n    " + "readOperationTimeout: " + this.getReadOperationTimeout() + "\n    " + "autoCreate: " + this.isAutoCreate();
    }
}

