/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.ehcache.clustered.client.internal.service.ValueCodec;
import org.ehcache.clustered.common.internal.store.ValueWrapper;

class ValueCodecFactory {
    ValueCodecFactory() {
    }

    static <T> ValueCodec<T> getCodecForClass(Class<T> clazz) {
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The provided type is invalid as it is not Serializable " + clazz);
        }
        if (Integer.class.equals(clazz) || Long.class.equals(clazz) || Float.class.equals(clazz) || Double.class.equals(clazz) || Byte.class.equals(clazz) || Character.class.equals(clazz) || clazz.isPrimitive() || String.class.equals(clazz)) {
            return new IdentityCodec();
        }
        return new SerializationWrapperCodec();
    }

    private static class SerializationWrapperCodec<T>
    implements ValueCodec<T> {
        private SerializationWrapperCodec() {
        }

        @Override
        public Object encode(T input) {
            if (input == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                try {
                    oos.writeObject(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Object cannot be serialized", e);
                }
                finally {
                    oos.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new ValueWrapper(input.hashCode(), baos.toByteArray());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T decode(Object input) {
            if (input == null) {
                return null;
            }
            ValueWrapper data = (ValueWrapper)input;
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getValue());
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                try {
                    Object result;
                    Object object = result = ois.readObject();
                    return (T)object;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load class", e);
                }
                finally {
                    ois.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Cannot reach here!");
            }
        }
    }

    private static class IdentityCodec<T>
    implements ValueCodec<T> {
        private IdentityCodec() {
        }

        @Override
        public Object encode(T input) {
            return input;
        }

        @Override
        public T decode(Object input) {
            return (T)input;
        }
    }
}

