/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.protocol.NullProtocolAdaptor;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerImpl;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.HealthCheckerProbeMessageFactory;
import com.tc.net.protocol.transport.HealthCheckerSocketConnect;
import com.tc.net.protocol.transport.HealthCheckerSocketConnectEventListener;
import com.tc.net.protocol.transport.HealthCheckerSocketConnectImpl;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.NullHealthCheckerSocketConnectImpl;
import com.tc.net.protocol.transport.TransportMessageFactoryImpl;
import com.tc.util.Assert;
import com.tc.util.State;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class ConnectionHealthCheckerContextImpl
implements ConnectionHealthCheckerContext,
HealthCheckerSocketConnectEventListener {
    private static final State INIT = new State("INIT");
    private static final State START = new State("START");
    private static final State ALIVE = new State("ALIVE");
    private static final State AWAIT_PINGREPLY = new State("AWAIT_PINGREPLY");
    private static final State SOCKET_CONNECT = new State("SOCKET_CONNECT");
    private static final State DEAD = new State("DEAD");
    public static final int CONFIG_UPGRADE_FACTOR = 3;
    private State currentState;
    private final TCLogger logger;
    private final MessageTransportBase transport;
    private final HealthCheckerProbeMessageFactory messageFactory;
    private final TCConnectionManager connectionManager;
    private final int maxProbeCountWithoutReply;
    private final AtomicLong probeReplyNotRecievedCount = new AtomicLong(0L);
    private final HealthCheckerConfig config;
    private final int callbackPort;
    private final String remoteNodeDesc;
    private int intervalTimeElapsedCount = 0;
    private int idleTimeElapsedCount = 0;
    private int socketConnectSuccessCount = 0;
    private int configFactor;
    private TCConnection presentConnection = null;
    private HealthCheckerSocketConnect sockectConnect = new NullHealthCheckerSocketConnectImpl();
    private final AtomicLong pingProbeSentCount = new AtomicLong(0L);
    private final long timeDiffThreshold;

    public ConnectionHealthCheckerContextImpl(MessageTransportBase mtb, HealthCheckerConfig config, TCConnectionManager connMgr) {
        this.transport = mtb;
        this.messageFactory = new TransportMessageFactoryImpl();
        this.maxProbeCountWithoutReply = config.getPingProbes();
        this.config = config;
        this.connectionManager = connMgr;
        this.timeDiffThreshold = config.getTimeDiffThreshold();
        this.logger = TCLogging.getLogger(ConnectionHealthCheckerImpl.class.getName() + ". " + config.getHealthCheckerName());
        this.remoteNodeDesc = mtb.getRemoteAddress().getCanonicalStringForm();
        this.logger.info("Health monitoring agent started for " + this.remoteNodeDesc);
        this.currentState = INIT;
        this.callbackPort = this.transport.getRemoteCallbackPort();
        this.configFactor = 1;
        this.initCallbackPortVerification();
    }

    private void initCallbackPortVerification() {
        if (this.config.isSocketConnectOnPingFail()) {
            HealthCheckerSocketConnect.SocketConnectStartStatus status = this.initSocketConnectProbe();
            if (status == HealthCheckerSocketConnect.SocketConnectStartStatus.FAILED) {
                this.callbackPortVerificationFailed();
            } else if (status == HealthCheckerSocketConnect.SocketConnectStartStatus.NOT_STARTED) {
                this.changeState(START);
            } else if (status != HealthCheckerSocketConnect.SocketConnectStartStatus.STARTED) {
                throw new AssertionError((Object)"initCallbackPortVerification: Unexpected SocketConnectStart Status");
            }
        } else {
            this.logger.info("HealthCheck SocketConnect disabled for " + this.remoteNodeDesc + ". HealthCheckCallbackPort not verified");
            this.changeState(START);
        }
    }

    private void changeState(State newState) {
        if (this.logger.isDebugEnabled() && this.currentState != newState) {
            this.logger.debug("Context state change for " + this.remoteNodeDesc + " : " + this.currentState.toString() + " ===> " + newState.toString());
        }
        this.currentState = newState;
    }

    private boolean canPingProbe() {
        if (this.logger.isDebugEnabled() && this.probeReplyNotRecievedCount.get() > 0L) {
            this.logger.debug("PING_REPLY not received from " + this.remoteNodeDesc + " for " + this.probeReplyNotRecievedCount + " times (max allowed:" + this.getMaxProbeCountWithoutReply() + ").");
        }
        return this.probeReplyNotRecievedCount.get() < (long)this.getMaxProbeCountWithoutReply();
    }

    private int getMaxProbeCountWithoutReply() {
        return this.maxProbeCountWithoutReply * this.configFactor;
    }

    private HealthCheckerSocketConnect.SocketConnectStartStatus initSocketConnectProbe() {
        this.presentConnection = this.getNewConnection(this.connectionManager);
        this.sockectConnect = this.getHealthCheckerSocketConnector(this.presentConnection, this.transport, this.logger, this.config);
        this.sockectConnect.addSocketConnectEventListener(this);
        HealthCheckerSocketConnect.SocketConnectStartStatus status = this.sockectConnect.start();
        if (status == HealthCheckerSocketConnect.SocketConnectStartStatus.FAILED || status == HealthCheckerSocketConnect.SocketConnectStartStatus.NOT_STARTED) {
            this.clearPresentConnection();
        }
        return status;
    }

    protected TCConnection getNewConnection(TCConnectionManager connManager) {
        TCConnection connection = connManager.createConnection(new NullProtocolAdaptor());
        return connection;
    }

    protected HealthCheckerSocketConnect getHealthCheckerSocketConnector(TCConnection connection, MessageTransportBase transportBase, TCLogger loger, HealthCheckerConfig cnfg) {
        if (-1 == this.callbackPort) {
            this.logger.info("No HealthCheckCallbackPort handshaked for node " + this.remoteNodeDesc);
            return new NullHealthCheckerSocketConnectImpl();
        }
        TCSocketAddress sa = new TCSocketAddress(transportBase.getRemoteAddress().getAddress(), this.callbackPort);
        return new HealthCheckerSocketConnectImpl(sa, connection, this.remoteNodeDesc + "(callbackport:" + this.callbackPort + ")", loger, cnfg.getSocketConnectTimeout());
    }

    private void clearPresentConnection() {
        this.sockectConnect.removeSocketConnectEventListener(this);
        this.presentConnection = null;
    }

    @Override
    public synchronized void refresh() {
        this.initProbeCycle();
        this.initIntervalTimeElapsedCount();
        this.initIdleTimeElapsedCount();
        this.initSocketConnectCycle();
    }

    private void updateConfigFactor(int newFactor) {
        Assert.eval(newFactor >= 1);
        int currentConfigFactor = this.configFactor;
        this.configFactor = newFactor;
        this.initIntervalTimeElapsedCount();
        this.initIdleTimeElapsedCount();
        this.logger.info("Config Factor updated from  " + currentConfigFactor + " to " + this.configFactor);
    }

    private boolean isIntervalTimeElapsed() {
        ++this.intervalTimeElapsedCount;
        if (this.intervalTimeElapsedCount >= this.configFactor) {
            this.initIntervalTimeElapsedCount();
            return true;
        }
        return false;
    }

    private boolean isIdleTimeElapsed() {
        ++this.idleTimeElapsedCount;
        return this.idleTimeElapsedCount >= this.configFactor;
    }

    @Override
    public synchronized void checkTime() {
        if (this.currentState.equals(START) || this.currentState.equals(ALIVE)) {
            try {
                this.sendProbeMessage(this.messageFactory.createTimeCheck(this.transport.getConnectionId(), this.transport.getConnection()));
            }
            catch (IOException ioe) {
                this.logger.warn("probe problem", ioe);
            }
        }
    }

    @Override
    public synchronized boolean probeIfAlive() {
        if (!this.isIntervalTimeElapsed()) {
            return true;
        }
        if (!this.isIdleTimeElapsed()) {
            return true;
        }
        if (!this.currentState.equals(DEAD)) {
            if (this.currentState.equals(SOCKET_CONNECT)) {
                if (!this.sockectConnect.probeConnectStatus()) {
                    this.changeState(DEAD);
                }
            } else if (this.currentState.equals(START) || this.currentState.equals(ALIVE) || this.currentState.equals(AWAIT_PINGREPLY)) {
                if (this.canPingProbe()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Sending PING Probe to IDLE " + this.remoteNodeDesc);
                    }
                    try {
                        this.sendProbeMessage(this.messageFactory.createPing(this.transport.getConnectionId(), this.transport.getConnection()));
                    }
                    catch (IOException ioe) {
                        this.logger.warn("probe problem", ioe);
                        return false;
                    }
                    this.pingProbeSentCount.incrementAndGet();
                    this.probeReplyNotRecievedCount.incrementAndGet();
                    this.changeState(AWAIT_PINGREPLY);
                } else if (this.config.isSocketConnectOnPingFail()) {
                    this.changeState(SOCKET_CONNECT);
                    HealthCheckerSocketConnect.SocketConnectStartStatus status = this.initSocketConnectProbe();
                    if (status == HealthCheckerSocketConnect.SocketConnectStartStatus.FAILED || status == HealthCheckerSocketConnect.SocketConnectStartStatus.NOT_STARTED) {
                        this.changeState(DEAD);
                    }
                } else {
                    this.changeState(DEAD);
                }
            } else if (this.currentState.equals(INIT) && !this.sockectConnect.probeConnectStatus()) {
                this.callbackPortVerificationFailed();
            }
        }
        if (this.currentState.equals(DEAD)) {
            this.logger.info(this.remoteNodeDesc + " is DEAD");
            return false;
        }
        return true;
    }

    private void callbackPortVerificationFailed() {
        this.transport.setRemoteCallbackPort(-1);
        this.updateConfigFactor(3);
        this.changeState(START);
        this.logger.info("HealthCheckCallbackPort verification FAILED for " + this.remoteNodeDesc + "(callbackport: " + this.callbackPort + ")");
    }

    private void callbackPortVerificationSuccess() {
        this.changeState(START);
        this.logger.info("HealthCheckCallbackPort verification PASSED for " + this.remoteNodeDesc + "(callbackport: " + this.callbackPort + ")");
    }

    @Override
    public synchronized boolean receiveProbe(HealthCheckerProbeMessage message) {
        if (message.isPing()) {
            try {
                this.sendProbeMessage(this.messageFactory.createPingReply(this.transport.getConnectionId(), this.transport.getConnection()));
            }
            catch (IOException ioe) {
                this.logger.warn("probe problem", ioe);
                return false;
            }
        } else if (message.isPingReply()) {
            if (this.probeReplyNotRecievedCount.get() > 0L) {
                this.probeReplyNotRecievedCount.decrementAndGet();
            }
            if (this.probeReplyNotRecievedCount.get() <= 0L) {
                this.changeState(ALIVE);
            }
            if (this.wasInLongGC()) {
                this.initSocketConnectCycle();
            }
        } else if (message.isTimeCheck()) {
            long diff = Math.abs(System.currentTimeMillis() - message.getTime());
            if (diff > this.timeDiffThreshold) {
                this.handleTimeDesync(message, diff);
            }
        } else {
            return false;
        }
        return true;
    }

    void handleTimeDesync(HealthCheckerProbeMessage message, long diff) {
        this.logger.warn(String.format("%d min time difference between %s and %s has been detected", TimeUnit.MILLISECONDS.toMinutes(diff), message.getSource().getLocalAddress(), message.getSource().getRemoteAddress()));
    }

    private void sendProbeMessage(HealthCheckerProbeMessage message) throws IOException {
        this.transport.send(message);
    }

    public long getTotalProbesSent() {
        return this.pingProbeSentCount.get();
    }

    private void initProbeCycle() {
        this.probeReplyNotRecievedCount.set(0L);
    }

    private void initSocketConnectCycle() {
        this.socketConnectSuccessCount = 0;
    }

    private void initIntervalTimeElapsedCount() {
        this.intervalTimeElapsedCount = 0;
    }

    private void initIdleTimeElapsedCount() {
        this.idleTimeElapsedCount = 0;
    }

    private boolean wasInLongGC() {
        return this.socketConnectSuccessCount > 0;
    }

    private boolean canAcceptConnectionEvent(TCConnectionEvent event) {
        if (event.getSource() == this.presentConnection && this.currentState == SOCKET_CONNECT) {
            return true;
        }
        this.logger.info("Unexpected connection event: " + event + ". Current state: " + this.currentState);
        return false;
    }

    TCLogger getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void notifySocketConnectFail(TCConnectionEvent failureEvent) {
        if (this.currentState.equals(INIT)) {
            this.callbackPortVerificationFailed();
        } else if (this.canAcceptConnectionEvent(failureEvent)) {
            this.logger.warn("Socket Connect error event:" + failureEvent.toString() + " on " + this.remoteNodeDesc);
            this.changeState(DEAD);
        }
    }

    @Override
    public synchronized void notifySocketConnectSuccess(TCConnectionEvent successEvent) {
        if (this.currentState.equals(INIT)) {
            this.callbackPortVerificationSuccess();
        } else if (this.canAcceptConnectionEvent(successEvent)) {
            ++this.socketConnectSuccessCount;
            if (this.socketConnectSuccessCount < this.config.getSocketConnectMaxCount()) {
                this.logger.warn(this.remoteNodeDesc + " might be in Long GC. Ping-probe cycles completed since last reply : " + this.socketConnectSuccessCount);
                this.initProbeCycle();
                this.changeState(ALIVE);
            } else {
                this.logger.error(this.remoteNodeDesc + " might be in Long GC. Ping-probe cycles completed since last reply : " + this.socketConnectSuccessCount + ". But its too long. No more retries");
                this.changeState(DEAD);
            }
        }
    }
}

