/*
 * Decompiled with CFR 0.152.
 */
package com.tc.logging;

import com.tc.logging.LogLevel;
import com.tc.logging.TCLogger;
import com.tc.util.Assert;

public class LossyTCLogger
implements TCLogger {
    public static final long DEFAULT_LOG_TIME_INTERVAL = 5000L;
    private final TCLogger logger;
    private final String lossyInfo;
    private LogOrNot decider;
    private long logCount = 0L;

    public LossyTCLogger(TCLogger logger) {
        this(logger, 5000L);
    }

    public LossyTCLogger(TCLogger logger, long logInterval) {
        this(logger, logInterval, LossyTCLoggerType.TIME_BASED);
    }

    public LossyTCLogger(TCLogger logger, long logInterval, LossyTCLoggerType type) {
        this(logger, logInterval, type, false);
    }

    public LossyTCLogger(TCLogger logger, long logInterval, LossyTCLoggerType type, boolean lossyLogOnlyIfSameContent) {
        Assert.eval(logInterval > 0L);
        this.logger = logger;
        this.decider = type == LossyTCLoggerType.TIME_BASED ? new TimeBasedDecider(logInterval, lossyLogOnlyIfSameContent) : new CountBasedDecider(logInterval, lossyLogOnlyIfSameContent);
        this.lossyInfo = " [lossy interval: " + logInterval + (type == LossyTCLoggerType.TIME_BASED ? "ms]" : "]");
        this.logCount = 0L;
    }

    @Override
    public void debug(Object message) {
        if (this.decider.canLog(message)) {
            this.logger.debug(message + this.lossyInfo);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.decider.canLog(message)) {
            this.logger.debug(message + this.lossyInfo, t);
        }
    }

    @Override
    public void error(Object message) {
        this.logger.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }

    @Override
    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
    }

    @Override
    public void info(Object message) {
        if (this.decider.canLog(message)) {
            this.logger.info(message);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.decider.canLog(message)) {
            this.logger.info(message, t);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.decider.canLog(message)) {
            this.logger.warn(message + this.lossyInfo);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.decider.canLog(message)) {
            this.logger.warn(message, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void setLevel(LogLevel level) {
        this.logger.setLevel(level);
    }

    @Override
    public LogLevel getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    public boolean isLoggingEnabledNow() {
        return this.decider.isLoggingEnabledNow();
    }

    private synchronized void updateLogCount() {
        ++this.logCount;
    }

    synchronized long getLogCount() {
        return this.logCount;
    }

    private class CountBasedDecider
    implements LogOrNot {
        private final long countInterval;
        private final boolean lossyLogOnlyIfSameContent;
        private Object prevMessage = null;
        private long count;

        CountBasedDecider(long logInterval, boolean lossyLogOnlyIfSameContent) {
            this.countInterval = logInterval;
            this.lossyLogOnlyIfSameContent = lossyLogOnlyIfSameContent;
            this.count = 0L;
        }

        @Override
        public synchronized boolean canLog(Object message) {
            if (this.lossyLogOnlyIfSameContent && (this.prevMessage == null || !this.prevMessage.equals(message))) {
                this.prevMessage = message;
                this.count = 1L;
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            this.prevMessage = message;
            if (this.count++ % this.countInterval == 0L) {
                this.count %= this.countInterval;
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            return false;
        }

        @Override
        public boolean isLoggingEnabledNow() {
            long remainder = this.count % this.countInterval;
            if (remainder != 0L) {
                ++this.count;
                return false;
            }
            return true;
        }
    }

    private class TimeBasedDecider
    implements LogOrNot {
        private final long timeInterval;
        private final boolean lossyLogOnlyIfSameContent;
        private long then;
        private Object prevMessage = null;

        TimeBasedDecider(long logInterval, boolean lossyLogOnlyIfSameContent) {
            this.timeInterval = logInterval;
            this.lossyLogOnlyIfSameContent = lossyLogOnlyIfSameContent;
        }

        @Override
        public synchronized boolean canLog(Object message) {
            long now = System.currentTimeMillis();
            if (this.lossyLogOnlyIfSameContent && (this.prevMessage == null || !this.prevMessage.equals(message))) {
                this.prevMessage = message;
                this.then = System.currentTimeMillis();
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            this.prevMessage = message;
            if (now > this.then + this.timeInterval) {
                this.then = now;
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            return false;
        }

        @Override
        public boolean isLoggingEnabledNow() {
            return System.currentTimeMillis() > this.then + this.timeInterval;
        }
    }

    static interface LogOrNot {
        public boolean canLog(Object var1);

        public boolean isLoggingEnabledNow();
    }

    public static enum LossyTCLoggerType {
        TIME_BASED,
        COUNT_BASED;

    }
}

