/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.object.EntityID;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.LogicalAction;
import com.tc.object.dna.api.PhysicalAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VersionizedDNAWrapper
implements DNA {
    private final long version;
    private final DNA dna;
    private final boolean resetSupported;

    public VersionizedDNAWrapper(DNA dna, long version) {
        this(dna, version, false);
    }

    public VersionizedDNAWrapper(DNA dna, long version, boolean resetSupported) {
        this.dna = dna;
        this.version = version;
        this.resetSupported = resetSupported;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public boolean hasLength() {
        return this.dna.hasLength();
    }

    @Override
    public int getArraySize() {
        return this.dna.getArraySize();
    }

    @Override
    public EntityID getEntityID() {
        return this.dna.getEntityID();
    }

    @Override
    public DNACursor getCursor() {
        return this.resetSupported ? new ResetableDNACursor(this.dna.getCursor()) : this.dna.getCursor();
    }

    @Override
    public boolean isDelta() {
        return this.dna.isDelta();
    }

    public String toString() {
        return this.dna.toString();
    }

    private static class ResetableDNACursor
    implements DNACursor {
        private final DNACursor cursor;
        private final List<Object> actions = new ArrayList<Object>();
        private int index = -1;

        public ResetableDNACursor(DNACursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public int getActionCount() {
            return this.cursor.getActionCount();
        }

        @Override
        public boolean next() throws IOException {
            if (++this.index < this.actions.size()) {
                return true;
            }
            boolean success = this.cursor.next();
            if (success) {
                this.actions.add(this.cursor.getAction());
            }
            return success;
        }

        @Override
        public boolean next(DNAEncoding encoding) throws IOException, ClassNotFoundException {
            if (++this.index < this.actions.size()) {
                return true;
            }
            boolean success = this.cursor.next(encoding);
            if (success) {
                this.actions.add(this.cursor.getAction());
            }
            return success;
        }

        @Override
        public void reset() {
            this.index = -1;
        }

        @Override
        public LogicalAction getLogicalAction() {
            return this.index < this.actions.size() ? (LogicalAction)this.actions.get(this.index) : this.cursor.getLogicalAction();
        }

        @Override
        public PhysicalAction getPhysicalAction() {
            return this.index < this.actions.size() ? (PhysicalAction)this.actions.get(this.index) : this.cursor.getPhysicalAction();
        }

        @Override
        public Object getAction() {
            return this.index < this.actions.size() ? this.actions.get(this.index) : this.cursor.getAction();
        }

        public String toString() {
            return this.cursor.toString();
        }
    }
}

