/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class LifeCycleMessageCodec {
    private static final String CONFIG_PRESENT_FIELD = "configPresent";
    private final StructBuilder VALIDATE_MESSAGE_STRUCT_BUILDER_PREFIX = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).bool("configPresent", 30);
    private static final int CONFIGURE_MESSAGE_NEXT_INDEX = 40;
    private final StructBuilder CREATE_STORE_MESSAGE_STRUCT_BUILDER_PREFIX = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30);
    private static final int CREATE_STORE_NEXT_INDEX = 40;
    private static final Struct DESTROY_STORE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).build();
    private final Struct RELEASE_STORE_MESSAGE_STRUCT = DESTROY_STORE_MESSAGE_STRUCT;
    private final Struct validateMessageStruct;
    private final Struct createStoreMessageStruct;
    private final Struct validateStoreMessageStruct;
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();
    private final ConfigCodec configCodec;

    public LifeCycleMessageCodec(ConfigCodec configCodec) {
        this.configCodec = configCodec;
        this.validateMessageStruct = this.configCodec.injectServerSideConfiguration(this.VALIDATE_MESSAGE_STRUCT_BUILDER_PREFIX, 40).getUpdatedBuilder().build();
        this.validateStoreMessageStruct = this.createStoreMessageStruct = this.configCodec.injectServerStoreConfiguration(this.CREATE_STORE_MESSAGE_STRUCT_BUILDER_PREFIX, 40).getUpdatedBuilder().build();
    }

    public byte[] encode(LifecycleMessage message) {
        switch (message.getMessageType()) {
            case VALIDATE: {
                return this.encodeTierManagerValidateMessage((LifecycleMessage.ValidateStoreManager)message);
            }
            case CREATE_SERVER_STORE: {
                return this.encodeCreateStoreMessage((LifecycleMessage.CreateServerStore)message);
            }
            case VALIDATE_SERVER_STORE: {
                return this.encodeValidateStoreMessage((LifecycleMessage.ValidateServerStore)message);
            }
            case DESTROY_SERVER_STORE: {
                return this.encodeDestroyStoreMessage((LifecycleMessage.DestroyServerStore)message);
            }
            case RELEASE_SERVER_STORE: {
                return this.encodeReleaseStoreMessage((LifecycleMessage.ReleaseServerStore)message);
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle message: " + message.getClass());
    }

    private byte[] encodeReleaseStoreMessage(LifecycleMessage.ReleaseServerStore message) {
        StructEncoder<Void> encoder = this.RELEASE_STORE_MESSAGE_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        return encoder.encode().array();
    }

    private byte[] encodeDestroyStoreMessage(LifecycleMessage.DestroyServerStore message) {
        StructEncoder<Void> encoder = DESTROY_STORE_MESSAGE_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        return encoder.encode().array();
    }

    private byte[] encodeCreateStoreMessage(LifecycleMessage.CreateServerStore message) {
        StructEncoder<Void> encoder = this.createStoreMessageStruct.encoder();
        return this.encodeBaseServerStoreMessage(message, encoder);
    }

    private byte[] encodeValidateStoreMessage(LifecycleMessage.ValidateServerStore message) {
        return this.encodeBaseServerStoreMessage(message, this.validateStoreMessageStruct.encoder());
    }

    private byte[] encodeBaseServerStoreMessage(LifecycleMessage.BaseServerStore message, StructEncoder<Void> encoder) {
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        this.configCodec.encodeServerStoreConfiguration(encoder, message.getStoreConfiguration());
        return encoder.encode().array();
    }

    private byte[] encodeTierManagerValidateMessage(LifecycleMessage.ValidateStoreManager message) {
        return this.encodeTierManagerCreateOrValidate(message, message.getConfiguration(), this.validateMessageStruct.encoder());
    }

    private byte[] encodeTierManagerCreateOrValidate(LifecycleMessage message, ServerSideConfiguration config, StructEncoder<Void> encoder) {
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        if (config == null) {
            encoder.bool(CONFIG_PRESENT_FIELD, false);
        } else {
            encoder.bool(CONFIG_PRESENT_FIELD, true);
            this.configCodec.encodeServerSideConfiguration(encoder, config);
        }
        return encoder.encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case VALIDATE: {
                return this.decodeValidateMessage(messageBuffer);
            }
            case CREATE_SERVER_STORE: {
                return this.decodeCreateServerStoreMessage(messageBuffer);
            }
            case VALIDATE_SERVER_STORE: {
                return this.decodeValidateServerStoreMessage(messageBuffer);
            }
            case DESTROY_SERVER_STORE: {
                return this.decodeDestroyServerStoreMessage(messageBuffer);
            }
            case RELEASE_SERVER_STORE: {
                return this.decodeReleaseServerStoreMessage(messageBuffer);
            }
        }
        throw new IllegalArgumentException("LifeCycleMessage operation not defined for : " + (Object)((Object)messageType));
    }

    private LifecycleMessage.ReleaseServerStore decodeReleaseServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.RELEASE_STORE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        LifecycleMessage.ReleaseServerStore message = new LifecycleMessage.ReleaseServerStore(storeName, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.DestroyServerStore decodeDestroyServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = DESTROY_STORE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        LifecycleMessage.DestroyServerStore message = new LifecycleMessage.DestroyServerStore(storeName, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.ValidateServerStore decodeValidateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.validateStoreMessageStruct.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.configCodec.decodeServerStoreConfiguration(decoder);
        LifecycleMessage.ValidateServerStore message = new LifecycleMessage.ValidateServerStore(storeName, config, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.CreateServerStore decodeCreateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.createStoreMessageStruct.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.configCodec.decodeServerStoreConfiguration(decoder);
        LifecycleMessage.CreateServerStore message = new LifecycleMessage.CreateServerStore(storeName, config, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.ValidateStoreManager decodeValidateMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.validateMessageStruct.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        boolean configPresent = decoder.bool(CONFIG_PRESENT_FIELD);
        ServerSideConfiguration config = null;
        if (configPresent) {
            config = this.configCodec.decodeServerSideConfiguration(decoder);
        }
        LifecycleMessage.ValidateStoreManager message = new LifecycleMessage.ValidateStoreManager(config, cliendId);
        if (msgId != null) {
            message.setId(msgId);
        }
        return message;
    }
}

