/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.management;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.management.SerializationHelper;
import java.io.IOException;

public class ResponseHolder
implements TCSerializable<ResponseHolder> {
    private byte[] serializedResponse;
    private byte[] serializedException;

    public ResponseHolder() {
    }

    public ResponseHolder(Exception exception) {
        this.serializedResponse = new byte[0];
        this.setException(exception);
    }

    public ResponseHolder(Object response) {
        this.setResponse(response);
        this.serializedException = new byte[0];
    }

    public Exception getException(ClassLoader classLoader) throws ClassNotFoundException {
        return (Exception)SerializationHelper.deserialize(this.serializedException, classLoader);
    }

    public void setException(Exception exception) {
        this.serializedException = SerializationHelper.serialize(exception);
    }

    public Object getResponse(ClassLoader classLoader) throws ClassNotFoundException {
        return SerializationHelper.deserialize(this.serializedResponse, classLoader);
    }

    public void setResponse(Object response) {
        this.serializedResponse = SerializationHelper.serialize(response);
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        if (this.serializedResponse == null) {
            serialOutput.writeInt(0);
        } else {
            serialOutput.writeInt(this.serializedResponse.length);
            serialOutput.write(this.serializedResponse);
        }
        if (this.serializedException == null) {
            serialOutput.writeInt(0);
        } else {
            serialOutput.writeInt(this.serializedException.length);
            serialOutput.write(this.serializedException);
        }
    }

    @Override
    public ResponseHolder deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        int responseLength = serialInput.readInt();
        this.serializedResponse = new byte[responseLength];
        serialInput.readFully(this.serializedResponse);
        int exceptionLength = serialInput.readInt();
        this.serializedException = new byte[exceptionLength];
        serialInput.readFully(this.serializedException);
        return this;
    }
}

