/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoltronEntityMultiResponseImpl
extends DSOMessageBase
implements VoltronEntityMultiResponse {
    private static final byte TRANSACTION_ID = 0;
    private static final byte RESULTS_ID = 1;
    private static final byte RECEIVED_ID = 2;
    private List<TransactionID> receivedIDs;
    private List<TransactionID> retiredIDs;
    private Map<TransactionID, byte[]> results;

    public VoltronEntityMultiResponseImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public VoltronEntityMultiResponseImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public synchronized boolean send() {
        return super.send();
    }

    public void setReceivedTransactions(TransactionID[] tids) {
        this.receivedIDs = Arrays.asList(tids);
    }

    public void setRetiredTransactions(TransactionID[] tids) {
        this.retiredIDs = Arrays.asList(tids);
    }

    public void setResults(Map<TransactionID, byte[]> r) {
        this.results = r;
    }

    @Override
    public synchronized boolean addReceived(TransactionID tid) {
        if (!this.isSealed()) {
            if (this.receivedIDs == null) {
                this.receivedIDs = new ArrayList<TransactionID>(128);
            }
            this.receivedIDs.add(tid);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addRetired(TransactionID tid) {
        if (!this.isSealed()) {
            if (this.retiredIDs == null) {
                this.retiredIDs = new ArrayList<TransactionID>(128);
            }
            this.retiredIDs.add(tid);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addResult(TransactionID tid, byte[] result) {
        if (!this.isSealed()) {
            if (this.results == null) {
                this.results = new HashMap<TransactionID, byte[]>();
            }
            this.results.put(tid, result);
            return true;
        }
        return false;
    }

    @Override
    public synchronized TransactionID[] getReceivedTransactions() {
        return this.receivedIDs != null ? this.receivedIDs.toArray(new TransactionID[this.receivedIDs.size()]) : new TransactionID[]{};
    }

    @Override
    public synchronized TransactionID[] getRetiredTransactions() {
        return this.retiredIDs != null ? this.retiredIDs.toArray(new TransactionID[this.retiredIDs.size()]) : new TransactionID[]{};
    }

    @Override
    public synchronized Map<TransactionID, byte[]> getResults() {
        return this.results == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.results);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        TCByteBufferInputStream input = this.getInputStream();
        if (name == 2) {
            int size = this.getIntValue();
            this.receivedIDs = new ArrayList<TransactionID>(size);
            for (int x = 0; x < size; ++x) {
                this.receivedIDs.add(new TransactionID(input.readLong()));
            }
            return true;
        }
        if (name == 0) {
            int size = this.getIntValue();
            this.retiredIDs = new ArrayList<TransactionID>(size);
            for (int x = 0; x < size; ++x) {
                this.retiredIDs.add(new TransactionID(input.readLong()));
            }
            return true;
        }
        int size = this.getIntValue();
        this.results = new HashMap<TransactionID, byte[]>();
        for (int x = 0; x < size; ++x) {
            TransactionID id = new TransactionID(input.readLong());
            byte[] read = new byte[input.readInt()];
            input.readFully(read);
            this.results.put(id, read);
        }
        return true;
    }

    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outputStream = this.getOutputStream();
        this.putNVPair((byte)2, this.receivedIDs != null ? this.receivedIDs.size() : 0);
        if (this.receivedIDs != null) {
            for (TransactionID transactionID : this.receivedIDs) {
                outputStream.writeLong(transactionID.toLong());
            }
        }
        this.putNVPair((byte)0, this.retiredIDs != null ? this.retiredIDs.size() : 0);
        if (this.retiredIDs != null) {
            for (TransactionID transactionID : this.retiredIDs) {
                outputStream.writeLong(transactionID.toLong());
            }
        }
        this.putNVPair((byte)1, this.results != null ? this.results.size() : 0);
        if (this.results != null) {
            for (Map.Entry entry : this.results.entrySet()) {
                outputStream.writeLong(((TransactionID)entry.getKey()).toLong());
                outputStream.writeInt(((byte[])entry.getValue()).length);
                outputStream.write((byte[])entry.getValue());
            }
        }
    }
}

