/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.concurrent.TimeUnit;
import org.ehcache.clustered.client.config.TimeoutDuration;

public final class Timeouts {
    public static final TimeoutDuration DEFAULT_READ_OPERATION_TIMEOUT = TimeoutDuration.of(20L, TimeUnit.SECONDS);
    private final TimeoutDuration readOperationTimeout;
    private final TimeoutDuration mutativeOperationTimeout;
    private final TimeoutDuration lifecycleOperationTimeout;

    private Timeouts(TimeoutDuration readOperationTimeout, TimeoutDuration mutativeOperationTimeout, TimeoutDuration lifecycleOperationTimeout) {
        this.readOperationTimeout = readOperationTimeout;
        this.mutativeOperationTimeout = mutativeOperationTimeout;
        this.lifecycleOperationTimeout = lifecycleOperationTimeout;
    }

    public TimeoutDuration getReadOperationTimeout() {
        return this.readOperationTimeout;
    }

    public TimeoutDuration getMutativeOperationTimeout() {
        return this.mutativeOperationTimeout;
    }

    public TimeoutDuration getLifecycleOperationTimeout() {
        return this.lifecycleOperationTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Timeouts{readOperationTimeout=" + this.readOperationTimeout + ", mutativeOperationTimeout=" + this.mutativeOperationTimeout + ", lifecycleOperationTimeout=" + this.lifecycleOperationTimeout + '}';
    }

    public static final class Builder {
        private TimeoutDuration readOperationTimeout = DEFAULT_READ_OPERATION_TIMEOUT;
        private TimeoutDuration mutativeOperationTimeout = TimeoutDuration.of(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        private TimeoutDuration lifecycleOperationTimeout = TimeoutDuration.of(20L, TimeUnit.SECONDS);

        public Builder setReadOperationTimeout(TimeoutDuration readOperationTimeout) {
            if (readOperationTimeout == null) {
                throw new NullPointerException("readOperationTimeout");
            }
            this.readOperationTimeout = readOperationTimeout;
            return this;
        }

        public Builder setMutativeOperationTimeout(TimeoutDuration mutativeOperationTimeout) {
            if (mutativeOperationTimeout == null) {
                throw new NullPointerException("mutativeOperationTimeout");
            }
            this.mutativeOperationTimeout = mutativeOperationTimeout;
            return this;
        }

        public Builder setLifecycleOperationTimeout(TimeoutDuration lifecycleOperationTimeout) {
            if (lifecycleOperationTimeout == null) {
                throw new NullPointerException("lifecycleOperationTimeout");
            }
            this.lifecycleOperationTimeout = lifecycleOperationTimeout;
            return this;
        }

        public Timeouts build() {
            return new Timeouts(this.readOperationTimeout, this.mutativeOperationTimeout, this.lifecycleOperationTimeout);
        }
    }
}

