/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;

public class Stack<T> {
    private final List<T> list = new ArrayList<T>();

    public T push(T item) {
        this.list.add(item);
        return item;
    }

    public T pop() {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.list.remove(len - 1);
    }

    public T peek() {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.list.get(len - 1);
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public int size() {
        return this.list.size();
    }

    public int search(T o) {
        int i = this.list.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public T remove(int index) {
        return this.list.remove(index);
    }

    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public boolean isEmpty() {
        return this.empty();
    }

    public boolean contains(T o) {
        return this.list.contains(o);
    }

    public boolean remove(T o) {
        return this.list.remove(o);
    }
}

