/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.object.ExceptionUtils;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.exception.EntityException;

public class InFlightMessage
implements InvokeFuture<byte[]> {
    private final VoltronEntityMessage message;
    private final Set<VoltronEntityMessage.Acks> pendingAcks;
    private final Set<Thread> waitingThreads;
    private boolean isSent;
    private EntityException exception;
    private byte[] value;
    private boolean canSetResult;
    private boolean getCanComplete;
    private final boolean blockGetOnRetired;

    public InFlightMessage(VoltronEntityMessage message, Set<VoltronEntityMessage.Acks> acks, boolean shouldBlockGetOnRetire) {
        this.message = message;
        this.pendingAcks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        this.pendingAcks.addAll(acks);
        this.waitingThreads = new HashSet<Thread>();
        this.blockGetOnRetired = shouldBlockGetOnRetire;
        this.canSetResult = true;
    }

    public VoltronEntityMessage getMessage() {
        return this.message;
    }

    public TransactionID getTransactionID() {
        return this.message.getTransactionID();
    }

    public boolean send() {
        Assert.assertFalse(this.isSent);
        this.isSent = true;
        return ((TCMessage)((Object)this.message)).send();
    }

    public synchronized void waitForAcks() {
        boolean interrupted = false;
        while (!this.pendingAcks.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void sent() {
        if (this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.SENT) && this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void received() {
        if (this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.RECEIVED) && this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void interrupt() {
        for (Thread waitingThread : this.waitingThreads) {
            waitingThread.interrupt();
        }
    }

    @Override
    public synchronized boolean isDone() {
        return this.getCanComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] get() throws InterruptedException, EntityException {
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        try {
            while (!this.getCanComplete) {
                this.wait();
            }
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
        if (this.exception != null) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(this.exception);
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        long end = System.nanoTime() + unit.toNanos(timeout);
        try {
            while (!this.getCanComplete) {
                long timing = end - System.nanoTime();
                if (timing <= 0L) {
                    throw new TimeoutException();
                }
                this.wait(timing / TimeUnit.MILLISECONDS.toNanos(1L), (int)(timing % TimeUnit.MILLISECONDS.toNanos(1L)));
            }
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
        if (this.exception != null) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(this.exception);
        }
        return this.value;
    }

    public synchronized void setResult(byte[] value, EntityException error) {
        this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.APPLIED);
        if (this.canSetResult) {
            this.exception = error;
            this.value = value;
            if (!this.blockGetOnRetired) {
                this.getCanComplete = true;
                this.notifyAll();
            }
            this.canSetResult = this.blockGetOnRetired;
        }
    }

    public synchronized void retired() {
        this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.RETIRED);
        if (this.blockGetOnRetired) {
            this.getCanComplete = true;
        }
        this.notifyAll();
    }
}

