/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ehcache.clustered.client.internal.store.ClusteredTierClientEntity;
import org.ehcache.clustered.client.internal.store.CommonServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.ReconnectMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrongServerStoreProxy.class);
    private final CommonServerStoreProxy delegate;
    private final ConcurrentMap<Long, CountDownLatch> hashInvalidationsInProgress = new ConcurrentHashMap<Long, CountDownLatch>();
    private final Lock invalidateAllLock = new ReentrantLock();
    private volatile CountDownLatch invalidateAllLatch;
    private final ClusteredTierClientEntity entity;
    private final ClusteredTierClientEntity.ReconnectListener reconnectListener;
    private final ClusteredTierClientEntity.DisconnectionListener disconnectionListener;

    public StrongServerStoreProxy(final String cacheId, ServerStoreMessageFactory messageFactory, ClusteredTierClientEntity entity) {
        this.delegate = new CommonServerStoreProxy(cacheId, messageFactory, entity);
        this.entity = entity;
        this.reconnectListener = new ClusteredTierClientEntity.ReconnectListener(){

            @Override
            public void onHandleReconnect(ReconnectMessage reconnectMessage) {
                Set<Long> inflightInvalidations = StrongServerStoreProxy.this.hashInvalidationsInProgress.keySet();
                reconnectMessage.addInvalidationsInProgress(StrongServerStoreProxy.this.delegate.getCacheId(), inflightInvalidations);
                if (StrongServerStoreProxy.this.invalidateAllLatch != null) {
                    reconnectMessage.addClearInProgress(StrongServerStoreProxy.this.delegate.getCacheId());
                }
            }
        };
        entity.setReconnectListener(this.reconnectListener);
        this.delegate.addResponseListeners(EhcacheEntityResponse.HashInvalidationDone.class, new ClusteredTierClientEntity.ResponseListener<EhcacheEntityResponse.HashInvalidationDone>(){

            @Override
            public void onResponse(EhcacheEntityResponse.HashInvalidationDone response) {
                long key = response.getKey();
                LOGGER.debug("CLIENT: on cache {}, server notified that clients invalidated hash {}", (Object)cacheId, (Object)key);
                CountDownLatch countDownLatch = (CountDownLatch)StrongServerStoreProxy.this.hashInvalidationsInProgress.remove(key);
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
            }
        });
        this.delegate.addResponseListeners(EhcacheEntityResponse.AllInvalidationDone.class, new ClusteredTierClientEntity.ResponseListener<EhcacheEntityResponse.AllInvalidationDone>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(EhcacheEntityResponse.AllInvalidationDone response) {
                CountDownLatch countDownLatch;
                LOGGER.debug("CLIENT: on cache {}, server notified that clients invalidated all", (Object)cacheId);
                StrongServerStoreProxy.this.invalidateAllLock.lock();
                try {
                    countDownLatch = StrongServerStoreProxy.this.invalidateAllLatch;
                    StrongServerStoreProxy.this.invalidateAllLatch = null;
                }
                finally {
                    StrongServerStoreProxy.this.invalidateAllLock.unlock();
                }
                if (countDownLatch != null) {
                    LOGGER.debug("CLIENT: on cache {}, count down", (Object)cacheId);
                    countDownLatch.countDown();
                }
            }
        });
        this.disconnectionListener = new ClusteredTierClientEntity.DisconnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnection() {
                for (Map.Entry entry : StrongServerStoreProxy.this.hashInvalidationsInProgress.entrySet()) {
                    ((CountDownLatch)entry.getValue()).countDown();
                }
                StrongServerStoreProxy.this.hashInvalidationsInProgress.clear();
                StrongServerStoreProxy.this.invalidateAllLock.lock();
                try {
                    if (StrongServerStoreProxy.this.invalidateAllLatch != null) {
                        StrongServerStoreProxy.this.invalidateAllLatch.countDown();
                    }
                }
                finally {
                    StrongServerStoreProxy.this.invalidateAllLock.unlock();
                }
            }
        };
        entity.setDisconnectionListener(this.disconnectionListener);
    }

    private <T> T performWaitingForHashInvalidation(long key, NullaryFunction<T> c) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        while (true) {
            if (!this.entity.isConnected()) {
                throw new IllegalStateException("Clustered tier manager disconnected");
            }
            CountDownLatch countDownLatch = this.hashInvalidationsInProgress.putIfAbsent(key, latch);
            if (countDownLatch == null) break;
            this.awaitOnLatch(countDownLatch);
        }
        try {
            T result = c.apply();
            LOGGER.debug("CLIENT: Waiting for invalidations on key {}", (Object)key);
            this.awaitOnLatch(latch);
            LOGGER.debug("CLIENT: key {} invalidated on all clients, unblocking call", (Object)key);
            return result;
        }
        catch (Exception ex) {
            this.hashInvalidationsInProgress.remove(key);
            latch.countDown();
            if (ex instanceof TimeoutException) {
                throw (TimeoutException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T performWaitingForAllInvalidation(NullaryFunction<T> c) throws InterruptedException, TimeoutException {
        CountDownLatch newLatch = new CountDownLatch(1);
        while (true) {
            CountDownLatch existingLatch;
            if (!this.entity.isConnected()) {
                throw new IllegalStateException("Clustered tier manager disconnected");
            }
            this.invalidateAllLock.lock();
            try {
                existingLatch = this.invalidateAllLatch;
                if (existingLatch == null) {
                    this.invalidateAllLatch = newLatch;
                    break;
                }
            }
            finally {
                this.invalidateAllLock.unlock();
            }
            this.awaitOnLatch(existingLatch);
        }
        try {
            T result = c.apply();
            this.awaitOnLatch(newLatch);
            LOGGER.debug("CLIENT: all invalidated on all clients, unblocking call");
            return result;
        }
        catch (Exception ex) {
            this.invalidateAllLock.lock();
            try {
                this.invalidateAllLatch = null;
            }
            finally {
                this.invalidateAllLock.unlock();
            }
            newLatch.countDown();
            if (ex instanceof TimeoutException) {
                throw (TimeoutException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private void awaitOnLatch(CountDownLatch countDownLatch) throws InterruptedException {
        int totalAwaitTime = 0;
        int backoff = 1;
        while (!countDownLatch.await(backoff, TimeUnit.SECONDS)) {
            backoff = backoff >= 10 ? 10 : backoff * 2;
            LOGGER.debug("Waiting for the server's InvalidationDone message for {}s, backing off {}s...", (Object)(totalAwaitTime += backoff), (Object)backoff);
        }
        if (!this.entity.isConnected()) {
            throw new IllegalStateException("Clustered tier manager disconnected");
        }
    }

    @Override
    public String getCacheId() {
        return this.delegate.getCacheId();
    }

    @Override
    public void addInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        this.delegate.addInvalidationListener(listener);
    }

    @Override
    public boolean removeInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        return this.delegate.removeInvalidationListener(listener);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        return this.delegate.get(key);
    }

    @Override
    public void append(final long key, final ByteBuffer payLoad) throws TimeoutException {
        try {
            this.performWaitingForHashInvalidation(key, new NullaryFunction<Void>(){

                @Override
                public Void apply() throws TimeoutException {
                    StrongServerStoreProxy.this.delegate.append(key, payLoad);
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public Chain getAndAppend(final long key, final ByteBuffer payLoad) throws TimeoutException {
        try {
            return this.performWaitingForHashInvalidation(key, new NullaryFunction<Chain>(){

                @Override
                public Chain apply() throws TimeoutException {
                    return StrongServerStoreProxy.this.delegate.getAndAppend(key, payLoad);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        this.delegate.replaceAtHead(key, expect, update);
    }

    @Override
    public void clear() throws TimeoutException {
        try {
            this.performWaitingForAllInvalidation(new NullaryFunction<Object>(){

                @Override
                public Object apply() throws TimeoutException {
                    StrongServerStoreProxy.this.delegate.clear();
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private static interface NullaryFunction<T> {
        public T apply() throws Exception;
    }
}

