/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.core.ConnectionAddressProvider;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactoryImpl;
import java.util.List;

public class MessageTransportFactoryImpl
implements MessageTransportFactory {
    private final TransportHandshakeMessageFactory transportMessageFactory;
    private final ConnectionHealthChecker connectionHealthChecker;
    private final TCConnectionManager connectionMgr;
    private final ConnectionAddressProvider addressProvider;
    private final int maxReconnectTries;
    private final int timeout;
    private final int callbackport;
    private final TransportHandshakeErrorHandler defaultHandshakeErrorHandler;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;
    private final TCSecurityManager securityManager;

    public MessageTransportFactoryImpl(TransportHandshakeMessageFactory transportMessageFactory, ConnectionHealthChecker connectionHealthChecker, TCConnectionManager connectionManager, ConnectionAddressProvider addressProvider, int maxReconnectTries, int timeout, int callbackPort, TransportHandshakeErrorHandler defaultHandshakeErrorHandler, ReconnectionRejectedHandler reconnectionRejectedBehaviour, TCSecurityManager securityManager) {
        this.transportMessageFactory = transportMessageFactory;
        this.connectionHealthChecker = connectionHealthChecker;
        this.connectionMgr = connectionManager;
        this.addressProvider = addressProvider;
        this.maxReconnectTries = maxReconnectTries;
        this.timeout = timeout;
        this.callbackport = callbackPort;
        this.defaultHandshakeErrorHandler = defaultHandshakeErrorHandler;
        this.reconnectionRejectedHandler = reconnectionRejectedBehaviour;
        this.securityManager = securityManager;
    }

    @Override
    public MessageTransport createNewTransport() {
        ClientConnectionEstablisher clientConnectionEstablisher = new ClientConnectionEstablisher(this.connectionMgr, this.addressProvider, this.maxReconnectTries, this.timeout, this.reconnectionRejectedHandler);
        ClientMessageTransport cmt = this.createClientMessageTransport(clientConnectionEstablisher, this.defaultHandshakeErrorHandler, this.transportMessageFactory, new WireProtocolAdaptorFactoryImpl(), this.callbackport);
        cmt.addTransportListener(this.connectionHealthChecker);
        return cmt;
    }

    protected ClientMessageTransport createClientMessageTransport(ClientConnectionEstablisher clientConnectionEstablisher, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPortNum) {
        return new ClientMessageTransport(clientConnectionEstablisher, handshakeErrorHandler, this.transportMessageFactory, wireProtocolAdaptorFactory, callbackPortNum, this.reconnectionRejectedHandler, this.securityManager, this.addressProvider);
    }

    @Override
    public MessageTransport createNewTransport(ConnectionID connectionID, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
        throw new AssertionError();
    }

    @Override
    public MessageTransport createNewTransport(ConnectionID connectionId, TCConnection connection, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
        throw new AssertionError();
    }
}

