/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.entity;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.ExceptionUtils;
import com.tc.util.Assert;
import com.tc.util.Throwables;
import com.tc.util.Util;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class TerracottaEntityRef<T extends Entity, C>
implements EntityRef<T, C> {
    private static final TCLogger logger = TCLogging.getLogger(TerracottaEntityRef.class);
    private final ClientEntityManager entityManager;
    private final Class<T> type;
    private final long version;
    private final String name;
    private final EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> entityClientService;
    private final AtomicLong nextClientInstanceID;

    public TerracottaEntityRef(ClientEntityManager entityManager, Class<T> type, long version, String name, EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> entityClientService, AtomicLong clientIds) {
        this.entityManager = entityManager;
        this.type = type;
        this.version = version;
        this.name = name;
        this.entityClientService = entityClientService;
        this.nextClientInstanceID = clientIds;
    }

    @Override
    public synchronized T fetchEntity() throws EntityNotFoundException, EntityVersionMismatchException {
        EntityClientEndpoint endpoint = null;
        try {
            ClientInstanceID clientInstanceID = new ClientInstanceID(this.nextClientInstanceID.getAndIncrement());
            EntityDescriptor entityDescriptor = new EntityDescriptor(this.getEntityID(), clientInstanceID, this.version);
            endpoint = this.entityManager.fetchEntity(entityDescriptor, this.entityClientService.getMessageCodec(), null);
        }
        catch (EntityException e) {
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            throw Assert.failure("Unsupported exception type returned to fetch", e);
        }
        catch (Throwable t) {
            Util.printLogAndRethrowError(t, logger);
        }
        if (endpoint == null) {
            Assert.assertNotNull(endpoint);
        }
        return this.entityClientService.create(endpoint);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private EntityID getEntityID() {
        return new EntityID(this.type.getName(), this.name);
    }

    @Override
    public void create(C configuration) throws EntityNotProvidedException, EntityAlreadyExistsException, EntityVersionMismatchException, EntityConfigurationException {
        EntityID entityID = this.getEntityID();
        try {
            this.entityManager.createEntity(entityID, this.version, this.entityClientService.serializeConfiguration(configuration));
        }
        catch (EntityException e) {
            e = ExceptionUtils.addLocalStackTraceToEntityException(e);
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            if (e instanceof EntityConfigurationException) {
                throw (EntityConfigurationException)e;
            }
            throw Assert.failure("Unsupported exception type returned to create", e);
        }
    }

    @Override
    public C reconfigure(C configuration) throws EntityNotProvidedException, EntityConfigurationException {
        EntityID entityID = this.getEntityID();
        try {
            return this.entityClientService.deserializeConfiguration(this.entityManager.reconfigureEntity(entityID, this.version, this.entityClientService.serializeConfiguration(configuration)));
        }
        catch (EntityException e) {
            e = ExceptionUtils.addLocalStackTraceToEntityException(e);
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityConfigurationException) {
                throw (EntityConfigurationException)e;
            }
            throw Assert.failure("Unsupported exception type returned to reconfigure", e);
        }
    }

    @Override
    public boolean destroy() throws EntityNotProvidedException, EntityNotFoundException, PermanentEntityException {
        try {
            return this.destroyEntity();
        }
        catch (EntityException e) {
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof PermanentEntityException) {
                throw (PermanentEntityException)e;
            }
            throw new RuntimeException("unexpected", e);
        }
    }

    private boolean destroyEntity() throws EntityNotProvidedException, EntityNotFoundException, PermanentEntityException {
        EntityID entityID = this.getEntityID();
        try {
            return this.entityManager.destroyEntity(entityID, this.version);
        }
        catch (EntityException e) {
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof PermanentEntityException) {
                throw (PermanentEntityException)e;
            }
            throw Throwables.propagate(e);
        }
    }
}

