/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.ha.ClusterState;
import com.tc.net.GroupID;
import com.tc.net.StripeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupToStripeMapSerializer;
import com.tc.net.groups.MessageID;
import com.tc.net.protocol.transport.ConnectionID;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClusterStateMessage
extends AbstractGroupMessage {
    public static final int NEW_CONNECTION_CREATED = 1;
    public static final int CONNECTION_DESTROYED = 2;
    public static final int COMPLETE_STATE = 240;
    public static final int OPERATION_FAILED_SPLIT_BRAIN = 254;
    public static final int OPERATION_SUCCESS = 255;
    private long nextAvailableObjectID;
    private long nextAvailableGID;
    private String clusterID;
    private ConnectionID connectionID;
    private long nextAvailableChannelID;
    private Set<ConnectionID> connectionIDs;
    private Map<GroupID, StripeID> stripeIDMap;

    public ClusterStateMessage() {
        super(-1);
    }

    public ClusterStateMessage(int type) {
        super(type);
    }

    public ClusterStateMessage(int type, MessageID requestID) {
        super(type, requestID);
    }

    public ClusterStateMessage(int type, ConnectionID connID) {
        super(type);
        this.connectionID = connID;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        switch (this.getType()) {
            case 1: 
            case 2: {
                this.connectionID = ConnectionID.readFrom(in);
                break;
            }
            case 240: {
                this.nextAvailableObjectID = in.readLong();
                this.nextAvailableGID = in.readLong();
                this.nextAvailableChannelID = in.readLong();
                this.clusterID = in.readString();
                int size = in.readInt();
                this.connectionIDs = new HashSet<ConnectionID>(size);
                for (int i = 0; i < size; ++i) {
                    this.connectionIDs.add(ConnectionID.readFrom(in));
                }
                GroupToStripeMapSerializer serializer = new GroupToStripeMapSerializer();
                serializer.deserializeFrom(in);
                this.stripeIDMap = serializer.getMap();
                break;
            }
            case 254: 
            case 255: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type : " + this.getType()));
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        switch (this.getType()) {
            case 1: 
            case 2: {
                this.connectionID.writeTo(out);
                break;
            }
            case 240: {
                out.writeLong(this.nextAvailableObjectID);
                out.writeLong(this.nextAvailableGID);
                out.writeLong(this.nextAvailableChannelID);
                out.writeString(this.clusterID);
                out.writeInt(this.connectionIDs.size());
                for (ConnectionID id : this.connectionIDs) {
                    id.writeTo(out);
                }
                new GroupToStripeMapSerializer(this.stripeIDMap).serializeTo(out);
                break;
            }
            case 254: 
            case 255: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type : " + this.getType()));
            }
        }
    }

    public long getNextAvailableObjectID() {
        return this.nextAvailableObjectID;
    }

    public long getNextAvailableGlobalTxnID() {
        return this.nextAvailableGID;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public ConnectionID getConnectionID() {
        return this.connectionID;
    }

    public void initMessage(ClusterState state) {
        switch (this.getType()) {
            case 240: {
                this.nextAvailableChannelID = state.getNextAvailableChannelID();
                this.clusterID = state.getStripeID().getName();
                this.connectionIDs = state.getAllConnections();
                this.stripeIDMap = state.getStripeIDMap();
                break;
            }
            default: {
                throw new AssertionError((Object)("Wrong Type : " + this.getType()));
            }
        }
    }

    public void initState(ClusterState state) {
        switch (this.getType()) {
            case 240: {
                state.setNextAvailableChannelID(this.nextAvailableChannelID);
                for (ConnectionID id : this.connectionIDs) {
                    state.addNewConnection(id);
                }
                for (GroupID gid : this.stripeIDMap.keySet()) {
                    state.addToStripeIDMap(gid, this.stripeIDMap.get(gid));
                }
                state.setStripeID(this.clusterID);
                break;
            }
            case 1: {
                state.addNewConnection(this.connectionID);
                break;
            }
            case 2: {
                state.removeConnection(this.connectionID);
                break;
            }
            default: {
                throw new AssertionError((Object)("Wrong Type : " + this.getType()));
            }
        }
    }

    public boolean isSplitBrainMessage() {
        return this.getType() == 254;
    }

    public static ClusterStateMessage createOKResponse(ClusterStateMessage msg) {
        ClusterStateMessage response = new ClusterStateMessage(255, msg.getMessageID());
        return response;
    }

    public static ClusterStateMessage createNGSplitBrainResponse(ClusterStateMessage msg) {
        ClusterStateMessage response = new ClusterStateMessage(254, msg.getMessageID());
        return response;
    }

    public static ClusterStateMessage createClusterStateMessage(ClusterState state) {
        ClusterStateMessage msg = new ClusterStateMessage(240);
        msg.initMessage(state);
        return msg;
    }

    public static ClusterStateMessage createNewConnectionCreatedMessage(ConnectionID connID) {
        ClusterStateMessage msg = new ClusterStateMessage(1, connID);
        return msg;
    }

    public static ClusterStateMessage createConnectionDestroyedMessage(ConnectionID connID) {
        ClusterStateMessage msg = new ClusterStateMessage(2, connID);
        return msg;
    }
}

