/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

class LifeCycleMessageCodec {
    private static final String CONFIG_PRESENT_FIELD = "configPresent";
    private static final String DEFAULT_RESOURCE_FIELD = "defaultResource";
    private static final String POOLS_SUB_STRUCT = "pools";
    private static final String POOL_NAME_FIELD = "poolName";
    private static final Struct POOLS_STRUCT = StructBuilder.newStructBuilder().string("poolName", 10).int64("poolSize", 20).string("resourceName", 30).build();
    private static final Struct CONFIGURE_MESSAGE_STRUCT;
    private static final Struct VALIDATE_MESSAGE_STRUCT;
    private static final Struct CREATE_STORE_MESSAGE_STRUCT;
    private static final Struct VALIDATE_STORE_MESSAGE_STRUCT;
    private static final Struct DESTROY_STORE_MESSAGE_STRUCT;
    private static final Struct RELEASE_STORE_MESSAGE_STRUCTU;
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();

    LifeCycleMessageCodec() {
    }

    public byte[] encode(LifecycleMessage message) {
        if (message instanceof LifecycleMessage.ConfigureStoreManager) {
            message.setId(System.nanoTime());
        }
        switch (message.getMessageType()) {
            case CONFIGURE: {
                return this.encodeTierManagerConfigureMessage((LifecycleMessage.ConfigureStoreManager)message);
            }
            case VALIDATE: {
                return this.encodeTierManagerValidateMessage((LifecycleMessage.ValidateStoreManager)message);
            }
            case CREATE_SERVER_STORE: {
                return this.encodeCreateStoreMessage((LifecycleMessage.CreateServerStore)message);
            }
            case VALIDATE_SERVER_STORE: {
                return this.encodeValidateStoreMessage((LifecycleMessage.ValidateServerStore)message);
            }
            case DESTROY_SERVER_STORE: {
                return this.encodeDestroyStoreMessage((LifecycleMessage.DestroyServerStore)message);
            }
            case RELEASE_SERVER_STORE: {
                return this.encodeReleaseStoreMessage((LifecycleMessage.ReleaseServerStore)message);
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle message: " + message.getClass());
    }

    private byte[] encodeReleaseStoreMessage(LifecycleMessage.ReleaseServerStore message) {
        StructEncoder encoder = RELEASE_STORE_MESSAGE_STRUCTU.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        return encoder.encode().array();
    }

    private byte[] encodeDestroyStoreMessage(LifecycleMessage.DestroyServerStore message) {
        StructEncoder encoder = DESTROY_STORE_MESSAGE_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        return encoder.encode().array();
    }

    private byte[] encodeCreateStoreMessage(LifecycleMessage.CreateServerStore message) {
        StructEncoder encoder = CREATE_STORE_MESSAGE_STRUCT.encoder();
        return this.encodeBaseServerStoreMessage(message, encoder);
    }

    private byte[] encodeValidateStoreMessage(LifecycleMessage.ValidateServerStore message) {
        return this.encodeBaseServerStoreMessage(message, VALIDATE_STORE_MESSAGE_STRUCT.encoder());
    }

    private byte[] encodeBaseServerStoreMessage(LifecycleMessage.BaseServerStore message, StructEncoder encoder) {
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        this.messageCodecUtils.encodeServerStoreConfiguration(encoder, message.getStoreConfiguration());
        return encoder.encode().array();
    }

    private byte[] encodeTierManagerConfigureMessage(LifecycleMessage.ConfigureStoreManager message) {
        return this.encodeTierManagerCreateOrValidate(message, message.getConfiguration(), CONFIGURE_MESSAGE_STRUCT.encoder());
    }

    private byte[] encodeTierManagerValidateMessage(LifecycleMessage.ValidateStoreManager message) {
        return this.encodeTierManagerCreateOrValidate(message, message.getConfiguration(), VALIDATE_MESSAGE_STRUCT.encoder());
    }

    private byte[] encodeTierManagerCreateOrValidate(LifecycleMessage message, ServerSideConfiguration config, StructEncoder encoder) {
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        this.encodeServerSideConfiguration(encoder, config);
        return encoder.encode().array();
    }

    private void encodeServerSideConfiguration(StructEncoder encoder, ServerSideConfiguration configuration) {
        if (configuration == null) {
            encoder.bool(CONFIG_PRESENT_FIELD, false);
        } else {
            encoder.bool(CONFIG_PRESENT_FIELD, true);
            if (configuration.getDefaultServerResource() != null) {
                encoder.string(DEFAULT_RESOURCE_FIELD, configuration.getDefaultServerResource());
            }
            if (!configuration.getResourcePools().isEmpty()) {
                StructArrayEncoder poolsEncoder = encoder.structs(POOLS_SUB_STRUCT);
                for (Map.Entry<String, ServerSideConfiguration.Pool> poolEntry : configuration.getResourcePools().entrySet()) {
                    poolsEncoder.string(POOL_NAME_FIELD, poolEntry.getKey()).int64("poolSize", poolEntry.getValue().getSize());
                    if (poolEntry.getValue().getServerResource() != null) {
                        poolsEncoder.string("resourceName", poolEntry.getValue().getServerResource());
                    }
                    poolsEncoder.next();
                }
                poolsEncoder.end();
            }
        }
    }

    private ServerSideConfiguration decodeServerSideConfiguration(StructDecoder decoder) {
        boolean configPresent = decoder.bool(CONFIG_PRESENT_FIELD);
        if (configPresent) {
            String defaultResource = decoder.string(DEFAULT_RESOURCE_FIELD);
            HashMap<String, ServerSideConfiguration.Pool> resourcePools = new HashMap<String, ServerSideConfiguration.Pool>();
            StructArrayDecoder poolStructs = decoder.structs(POOLS_SUB_STRUCT);
            if (poolStructs != null) {
                for (int i = 0; i < poolStructs.length(); ++i) {
                    String poolName = poolStructs.string(POOL_NAME_FIELD);
                    Long poolSize = poolStructs.int64("poolSize");
                    String poolResourceName = poolStructs.string("resourceName");
                    if (poolResourceName == null) {
                        resourcePools.put(poolName, new ServerSideConfiguration.Pool(poolSize));
                    } else {
                        resourcePools.put(poolName, new ServerSideConfiguration.Pool(poolSize, poolResourceName));
                    }
                    poolStructs.next();
                }
            }
            ServerSideConfiguration serverSideConfiguration = defaultResource == null ? new ServerSideConfiguration(resourcePools) : new ServerSideConfiguration(defaultResource, resourcePools);
            return serverSideConfiguration;
        }
        return null;
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case CONFIGURE: {
                return this.decodeConfigureMessage(messageBuffer);
            }
            case VALIDATE: {
                return this.decodeValidateMessage(messageBuffer);
            }
            case CREATE_SERVER_STORE: {
                return this.decodeCreateServerStoreMessage(messageBuffer);
            }
            case VALIDATE_SERVER_STORE: {
                return this.decodeValidateServerStoreMessage(messageBuffer);
            }
            case DESTROY_SERVER_STORE: {
                return this.decodeDestroyServerStoreMessage(messageBuffer);
            }
            case RELEASE_SERVER_STORE: {
                return this.decodeReleaseServerStoreMessage(messageBuffer);
            }
        }
        throw new IllegalArgumentException("LifeCycleMessage operation not defined for : " + (Object)((Object)messageType));
    }

    private LifecycleMessage.ReleaseServerStore decodeReleaseServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = RELEASE_STORE_MESSAGE_STRUCTU.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        LifecycleMessage.ReleaseServerStore message = new LifecycleMessage.ReleaseServerStore(storeName, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.DestroyServerStore decodeDestroyServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = DESTROY_STORE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        LifecycleMessage.DestroyServerStore message = new LifecycleMessage.DestroyServerStore(storeName, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.ValidateServerStore decodeValidateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = VALIDATE_STORE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.messageCodecUtils.decodeServerStoreConfiguration(decoder);
        LifecycleMessage.ValidateServerStore message = new LifecycleMessage.ValidateServerStore(storeName, config, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.CreateServerStore decodeCreateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CREATE_STORE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.messageCodecUtils.decodeServerStoreConfiguration(decoder);
        LifecycleMessage.CreateServerStore message = new LifecycleMessage.CreateServerStore(storeName, config, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.ValidateStoreManager decodeValidateMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = VALIDATE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID(decoder);
        ServerSideConfiguration config = this.decodeServerSideConfiguration(decoder);
        LifecycleMessage.ValidateStoreManager message = new LifecycleMessage.ValidateStoreManager(config, cliendId);
        if (msgId != null) {
            message.setId(msgId);
        }
        return message;
    }

    private LifecycleMessage.ConfigureStoreManager decodeConfigureMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CONFIGURE_MESSAGE_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        ServerSideConfiguration config = this.decodeServerSideConfiguration(decoder);
        LifecycleMessage.ConfigureStoreManager message = new LifecycleMessage.ConfigureStoreManager(config, clientId);
        if (msgId != null) {
            message.setId(msgId);
        }
        return message;
    }

    static {
        VALIDATE_MESSAGE_STRUCT = CONFIGURE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).bool(CONFIG_PRESENT_FIELD, 30).string(DEFAULT_RESOURCE_FIELD, 40).structs(POOLS_SUB_STRUCT, 50, POOLS_STRUCT).build();
        VALIDATE_STORE_MESSAGE_STRUCT = CREATE_STORE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).string("keyType", 40).string("keySerializerType", 41).string("valueType", 45).string("valueSerializerType", 46).enm("consistency", 50, MessageCodecUtils.CONSISTENCY_ENUM_MAPPING).int64("poolSize", 60).string("resourceName", 65).build();
        RELEASE_STORE_MESSAGE_STRUCTU = DESTROY_STORE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).build();
    }
}

